/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model;

import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.report.model.Messages;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.utility.io.CountedInputStream;
import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.common.utility.io.IProgressProvider;
import com.arm.streamline.common.utility.io.IProgressTracker;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.jni.apcdbgen.proto.SourceFile;
import com.arm.utils.NullChecking;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;

public class PathSubstitutionsFile {
    public static final String RELATIVE_PATH_REMAP_BASE = "/UNSPECIFIED";
    private static final String STATIC_FILENAME = "../path_overrides.xml";
    private static final String TAG_PATH_SUBSTITUTIONS = "path_substitutions";
    private static final String TAG_PATH_SUBSTITUTION = "path_substitution";
    private static final String ATTR_PREFIX = "prefix";
    private static final String ATTR_REPLACEMENT = "replacement";
    private final @NonNull Map<@NonNull String, @NonNull String> mPathSubstitutions = new HashMap<String, String>();
    private final @NonNull File reportDirectory;

    public static @NonNull String adjustPathForSubstitutions(@NonNull String path, Map<@NonNull String, @NonNull String> substitutions) {
        for (String key : PathSubstitutionsFile.getSubstitutionKeyOrder(substitutions)) {
            if (!path.startsWith(key)) continue;
            return (String)NullChecking.neverNull((Object)new File(substitutions.get(key), path.substring(key.length())).toString());
        }
        return path;
    }

    public static List<String> getSubstitutionKeyOrder(Map<String, String> substitutions) {
        ArrayList<String> keys = new ArrayList<String>(substitutions.keySet());
        Collections.sort(keys, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1.startsWith(o2)) {
                    return -1;
                }
                if (o2.startsWith(o1)) {
                    return 1;
                }
                return o1.compareTo(o2);
            }
        });
        return keys;
    }

    private static @NonNull File getFile(@NonNull File reportDir) {
        return CommonFileUtils.getFile((File)new File(reportDir, STATIC_FILENAME));
    }

    public PathSubstitutionsFile(@NonNull File reportDirectory, @NonNull IProgressTracker tracker) {
        tracker.setSubTaskTitle(Messages.PATH_SUBSTITUTIONS);
        this.reportDirectory = reportDirectory;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (CountedInputStream cin = new CountedInputStream(PathSubstitutionsFile.getFile(reportDirectory));){
                tracker.setProgressProvider((IProgressProvider)cin);
                Throwable throwable2 = null;
                Object var7_11 = null;
                try (XMLParser in = XMLParser.create((InputStream)cin);){
                    String tag;
                    while ((tag = in.nextTag()) != null) {
                        if (TAG_PATH_SUBSTITUTIONS.equals(tag)) {
                            String marker = in.getMarker();
                            while ((tag = in.nextTag(marker)) != null) {
                                if (TAG_PATH_SUBSTITUTION.equals(tag)) {
                                    String prefix = in.getAttribute(ATTR_PREFIX, "");
                                    String replacement = in.getAttribute(ATTR_REPLACEMENT, "");
                                    if (prefix.isEmpty()) continue;
                                    this.mPathSubstitutions.put(prefix, replacement);
                                    tracker.update();
                                    continue;
                                }
                                in.skip();
                            }
                        } else {
                            in.skip();
                        }
                        tracker.update();
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                tracker.update();
                tracker.setProgressProvider(null);
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public @NonNull Map<@NonNull String, @NonNull String> getPathSubstitutions() {
        return this.mPathSubstitutions;
    }

    public boolean isSpecialDirectory(@NonNull String directory, boolean filterApcPaths) {
        String path = FilePath.getFullPath((File)this.reportDirectory);
        if ((directory = (String)NullChecking.neverNull((Object)FilePath.normalizeFullPath((String)directory))).endsWith(FilePath.PATH_SEPARATOR)) {
            directory = directory.substring(0, directory.length() - 1);
        }
        if (path.equals(directory)) {
            return true;
        }
        if (filterApcPaths) {
            if (FilePath.getParent((String)path, (boolean)false).equals(directory)) {
                return true;
            }
            String dir = directory.toLowerCase();
            if (dir.contains(".apc/") || dir.endsWith(".apc")) {
                return true;
            }
        }
        return false;
    }

    public void save() {
        block14: {
            try {
                File file = PathSubstitutionsFile.getFile(this.reportDirectory);
                if (this.mPathSubstitutions.isEmpty()) {
                    file.delete();
                    break block14;
                }
                Throwable throwable = null;
                Object var3_5 = null;
                try (XMLGenerator xml = XMLGenerator.create((File)file);){
                    xml.startDocument();
                    xml.startTag(TAG_PATH_SUBSTITUTIONS);
                    if (!this.mPathSubstitutions.isEmpty()) {
                        for (Map.Entry<String, String> entry : this.mPathSubstitutions.entrySet()) {
                            xml.startEmptyTag(TAG_PATH_SUBSTITUTION);
                            xml.addAttribute(ATTR_PREFIX, entry.getKey());
                            xml.addAttribute(ATTR_REPLACEMENT, entry.getValue());
                        }
                    }
                    xml.endTag();
                    xml.endDocument();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                CommonPlugin.error((Throwable)exception);
            }
        }
    }

    public @NonNull String computeUpdatedPath(@NonNull SourceFile sourceFile) {
        String name = sourceFile.getFileName();
        String dir = FilePath.normalizeFullPath((String)sourceFile.getParentPath());
        assert (dir != null);
        if (dir.isEmpty() || !FilePath.isFullPath((String)dir)) {
            dir = FilePath.getFullPath((String)RELATIVE_PATH_REMAP_BASE, (String)dir);
        }
        if (!this.isSpecialDirectory(dir, false)) {
            return FilePath.getFullPath((String)PathSubstitutionsFile.adjustPathForSubstitutions(dir, this.getPathSubstitutions()), (String)name);
        }
        return (String)NullChecking.neverNull((Object)FilePath.normalizeFullPath((String)sourceFile.filePath));
    }
}

