/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util;

public class Tuple<TA, TB> {
    public final TA ta;
    public final TB tb;

    public static <TA, TB> Tuple<TA, TB> getInstance(TA a, TB b) {
        return new Tuple<TA, TB>(a, b);
    }

    public Tuple(TA ta, TB tb) {
        this.ta = ta;
        this.tb = tb;
    }

    public boolean equals(Object obj) {
        boolean equals;
        if (this == obj) {
            equals = true;
        } else if (obj instanceof Tuple) {
            Tuple t = (Tuple)obj;
            equals = Tuple.safeCompare(this.ta, t.ta) && Tuple.safeCompare(this.tb, t.tb);
        } else {
            equals = false;
        }
        return equals;
    }

    public int hashCode() {
        TA ta = this.ta;
        TB tb = this.tb;
        if (ta == null && tb == null) {
            return 0;
        }
        if (ta == null) {
            return tb.hashCode();
        }
        if (tb == null) {
            return ta.hashCode();
        }
        return tb.hashCode() ^ ta.hashCode();
    }

    public String toString() {
        return "(" + String.valueOf(this.ta) + ", " + String.valueOf(this.tb) + ")";
    }

    private static boolean safeCompare(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (b == null || a == null) {
            return false;
        }
        return a.equals(b);
    }
}

