/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util;

import com.arm.util.Tuple;

public class Platform {
    public static final String ARCH = System.getProperty("os.arch");
    public static final String FS = System.getProperty("file.separator");
    public static final String LS = System.getProperty("line.separator");
    public static final String OS = System.getProperty("os.name");
    public static final String PS = System.getProperty("path.separator");
    public static final String TMP = System.getProperty("java.io.tmpdir");
    private static final String LINUX = "linux";
    private static final String MAC = "mac";
    private static final String WINDOWS = "windows";

    public static Tuple<String, String> getId() {
        String platform = "unknown";
        if (Platform.isWindows()) {
            platform = WINDOWS;
        } else if (Platform.isLinux()) {
            platform = LINUX;
        } else if (Platform.isMac()) {
            platform = MAC;
        }
        return new Tuple<String, String>(platform, Platform.getArchName());
    }

    public static boolean isArm() {
        return Platform.getArchName().startsWith("arm");
    }

    public static boolean isLinux() {
        return OS.toLowerCase().startsWith(LINUX);
    }

    public static boolean isMac() {
        return OS.toLowerCase().startsWith(MAC);
    }

    public static boolean isWindows() {
        return OS.toLowerCase().startsWith(WINDOWS);
    }

    public static final boolean isWindowsVistaOrNewer() {
        if (Platform.isWindows()) {
            double version;
            try {
                version = Double.parseDouble(System.getProperty("os.version").trim());
            }
            catch (Exception exception) {
                version = 0.0;
            }
            return version >= 6.0;
        }
        return false;
    }

    public static boolean isX86() {
        String arch = Platform.getArchName();
        return "i386".equals(arch) || arch.startsWith("x86");
    }

    static String getArchName() {
        String arch = System.getProperty("os.arch").toLowerCase();
        if (arch.startsWith("amd64")) {
            arch = "x86_64";
        }
        return arch;
    }

    private Platform() {
    }
}

