/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.wizard.import_astf.viewmodel;

import com.arm.streamline.application.preferences.StreamlinePreferences;
import com.arm.streamline.wizard.import_astf.Messages;
import com.arm.utils.NullChecking;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.List;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ASTFCaptureViewModel {
    private final @NonNull WritableValue<@Nullable String> observableCapturePath = new WritableValue();
    private final @NonNull File suggestedCaptureFolder;

    public @NonNull WritableValue<@Nullable String> getObservableCapturePath() {
        return this.observableCapturePath;
    }

    public ASTFCaptureViewModel(@NonNull File suggestedCaptureFolder) {
        this.suggestedCaptureFolder = suggestedCaptureFolder;
    }

    public @NonNull ValidationStatusProvider getValidationStatusProvider() {
        return new MultiValidator(){

            protected IStatus validate() {
                @Nullable String captureFolderPathString = (String)ASTFCaptureViewModel.this.observableCapturePath.getValue();
                if (captureFolderPathString == null || captureFolderPathString.isEmpty()) {
                    return ValidationStatus.error((String)Messages.ImportASTF_ASTF_CaptureName_Missing);
                }
                @NonNull File captureFolderFile = new File(captureFolderPathString);
                if (!this.isValidCaptureName(captureFolderFile)) {
                    return ValidationStatus.error((String)Messages.ImportASTF_ASTF_CaptureName_Invalid);
                }
                @NonNull File captureFolderParentFile = (File)NullChecking.neverNull((Object)captureFolderFile.getParentFile());
                if (!this.isCaptureParentFolderExists(captureFolderParentFile)) {
                    return ValidationStatus.error((String)Messages.ImportASTF_ASTF_CaptureParentFolder_Invalid);
                }
                if (this.isParentFolderRW(captureFolderParentFile)) {
                    return ValidationStatus.error((String)Messages.ImportASTF_ASTF_CaptureParentFolder_PermissionDenied);
                }
                if (captureFolderFile.exists()) {
                    return ValidationStatus.error((String)Messages.ImportASTF_ASTF_CaptureName_Exists);
                }
                if (!captureFolderPathString.endsWith(".apc")) {
                    return ValidationStatus.error((String)Messages.ImportASTF_ASTF_CaptureName_Not_APC);
                }
                List<File> dataLocations = StreamlinePreferences.getDataLocations();
                if (!dataLocations.contains(captureFolderParentFile)) {
                    return ValidationStatus.warning((String)Messages.ImportASTF_ASTF_CaptureFolder_NotInWatchList);
                }
                return ValidationStatus.ok();
            }

            private boolean isParentFolderRW(@NonNull File captureFolderParentPath) {
                return !Files.isReadable(Paths.get(captureFolderParentPath.getAbsolutePath(), new String[0])) || !Files.isWritable(Paths.get(captureFolderParentPath.getAbsolutePath(), new String[0]));
            }

            private boolean isCaptureParentFolderExists(@NonNull File captureFolderParentPath) {
                return Files.exists(Paths.get(captureFolderParentPath.getAbsolutePath(), new String[0]), new LinkOption[0]);
            }

            private boolean isValidCaptureName(@NonNull File captureFolderPath) {
                try {
                    captureFolderPath.getCanonicalPath();
                    return true;
                }
                catch (IOException e) {
                    return false;
                }
            }
        };
    }

    public @NonNull File getSuggestedCaptureFolder() {
        return this.suggestedCaptureFolder;
    }

    public @Nullable File getParentCaptureFile() {
        return this.observableCapturePath.getValue() == null ? null : new File((String)this.observableCapturePath.getValue()).getParentFile();
    }
}

