/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.wizard.import_astf.viewmodel;

import com.arm.databinding.PropertyOnObservable;
import com.arm.streamline.wizard.import_astf.Messages;
import com.arm.streamline.wizard.import_astf.viewmodel.ASTFImportFileModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.list.ComputedList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.WritableMap;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class ASTFAddFileViewModel {
    private final @NonNull ComputedList<@NonNull ASTFImportFileModel> observableAllASTFfiles;
    private final @NonNull WritableList<@NonNull ASTFImportFileModel> observableAddNewFiles;
    private final @NonNull WritableList<@NonNull ASTFImportFileModel> observableSelectedFiles;
    private final @NonNull WritableList<@NonNull ASTFImportFileModel> observableAstfFilesFromDialogList;
    private final @NonNull IObservableValue<@Nullable String> observableTooltipText;
    private final @NonNull WritableValue<@NonNull ASTFFileActions> observableFileActionMode = new WritableValue();
    private final @NonNull WritableValue<@NonNull Boolean> observableValidateFilesPresent = new WritableValue((Object)Boolean.FALSE, Boolean.TYPE);
    private @NonNull ComputedValue<@NonNull Boolean> observableValidateClustersAndCoresSet;
    private @NonNull List<@NonNull ASTFImportFileModel> previousList = new ArrayList<ASTFImportFileModel>();
    private final @NonNull IObservableMap<@NonNull ASTFImportFileModel, @NonNull WritableValue<Integer>> clusterIdObservables = new WritableMap(ASTFImportFileModel.class, WritableValue.class);
    private final @NonNull IObservableMap<@NonNull ASTFImportFileModel, @NonNull WritableValue<Integer>> coreIdObservables = new WritableMap(ASTFImportFileModel.class, WritableValue.class);
    private final @NonNull WritableValue<@NonNull Boolean> multiCoreMode = new WritableValue((Object)Boolean.FALSE, Boolean.TYPE);

    public ASTFAddFileViewModel() {
        this.observableAddNewFiles = new WritableList(new ArrayList(), ASTFImportFileModel.class);
        this.observableSelectedFiles = new WritableList(new ArrayList(), ASTFImportFileModel.class);
        this.observableAstfFilesFromDialogList = new WritableList(new ArrayList(), ASTFImportFileModel.class);
        this.observableFileActionMode.setValue((Object)ASTFFileActions.NONE);
        this.observableAllASTFfiles = new ComputedList<ASTFImportFileModel>(){

            protected @NonNull List<@NonNull ASTFImportFileModel> calculate() {
                @NonNull ArrayList<@NonNull ASTFImportFileModel> astfFiles = new ArrayList<ASTFImportFileModel>(ASTFAddFileViewModel.this.previousList);
                switch ((ASTFFileActions)((Object)ASTFAddFileViewModel.this.observableFileActionMode.getValue())) {
                    case ADD: {
                        if (ASTFAddFileViewModel.this.observableAddNewFiles.isEmpty()) break;
                        ASTFAddFileViewModel.this.observableAddNewFiles.stream().forEach(c -> {
                            if (astfFiles.stream().noneMatch(astfFile -> astfFile.getFileName().equals(c.getFileName()))) {
                                if (!((Boolean)ASTFAddFileViewModel.this.multiCoreMode.getValue()).booleanValue()) {
                                    c.setClusterId(0);
                                    c.setCoreId(0);
                                }
                                astfFiles.add((ASTFImportFileModel)c);
                            }
                        });
                        ASTFAddFileViewModel.this.observableAddNewFiles.clear();
                        break;
                    }
                    case REMOVE: {
                        if (ASTFAddFileViewModel.this.observableSelectedFiles.isEmpty()) break;
                        ASTFAddFileViewModel.this.observableSelectedFiles.stream().forEach(c -> {
                            astfFiles.remove(c);
                            ASTFAddFileViewModel.this.removeFileFromClusterAndCoreIdCaches((ASTFImportFileModel)c);
                        });
                        break;
                    }
                    case UP: {
                        int indexOf;
                        int indexPrevious;
                        if (ASTFAddFileViewModel.this.observableSelectedFiles.isEmpty() || ASTFAddFileViewModel.this.observableSelectedFiles.size() != 1 || (indexPrevious = (indexOf = astfFiles.indexOf(ASTFAddFileViewModel.this.observableSelectedFiles.get(0))) - 1) < 0) break;
                        Collections.swap(astfFiles, indexPrevious, indexOf);
                        break;
                    }
                    case DOWN: {
                        if (ASTFAddFileViewModel.this.observableSelectedFiles.isEmpty() || ASTFAddFileViewModel.this.observableSelectedFiles.size() != 1) break;
                        int indexOf = astfFiles.indexOf(ASTFAddFileViewModel.this.observableSelectedFiles.get(0));
                        int indexNext = indexOf + 1;
                        if (indexOf < 0 || indexNext >= astfFiles.size()) break;
                        Collections.swap(astfFiles, indexNext, indexOf);
                        break;
                    }
                    case NONE: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected value: " + String.valueOf(ASTFAddFileViewModel.this.observableFileActionMode));
                    }
                }
                ASTFAddFileViewModel.this.previousList = astfFiles.stream().collect(Collectors.toList());
                ASTFAddFileViewModel.this.observableFileActionMode.setValue((Object)ASTFFileActions.NONE);
                ASTFAddFileViewModel.this.observableValidateFilesPresent.setValue((Object)(astfFiles.size() > 0 ? Boolean.TRUE : Boolean.FALSE));
                return astfFiles;
            }
        };
        this.observableValidateClustersAndCoresSet = new ComputedValue<Boolean>(){

            protected Boolean calculate() {
                for (Map.Entry entry : ASTFAddFileViewModel.this.clusterIdObservables.entrySet()) {
                    Integer clusterId = (Integer)((WritableValue)entry.getValue()).getValue();
                    if (clusterId != null) continue;
                    return Boolean.FALSE;
                }
                for (Map.Entry entry : ASTFAddFileViewModel.this.coreIdObservables.entrySet()) {
                    Integer coreId = (Integer)((WritableValue)entry.getValue()).getValue();
                    if (coreId != null) continue;
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        };
        this.observableTooltipText = ComputedValue.create(() -> this.observableAllASTFfiles.isEmpty() ? Messages.ImportASTF_AstfFilesToolTip : null);
    }

    public @NonNull ComputedList<@NonNull ASTFImportFileModel> getPropertyAllItems() {
        return this.observableAllASTFfiles;
    }

    public @NonNull IObservableValue<@Nullable String> getPropertyTooltipText() {
        return this.observableTooltipText;
    }

    public @NonNull WritableList<@NonNull ASTFImportFileModel> getPropertyNewFilesAdded() {
        return this.observableAddNewFiles;
    }

    public static @NonNull IValueProperty<@NonNull ASTFImportFileModel, @NonNull String> getFileInputProperty() {
        return new PropertyOnObservable<ASTFImportFileModel, String>(String.class){

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            protected @NonNull IObservableValue<@NonNull String> getObservable(@NonNull ASTFImportFileModel source) {
                @NonNull WritableValue writableValue = new WritableValue();
                writableValue.setValue((Object)source.getFileName());
                return writableValue;
            }
        };
    }

    public @NonNull IValueProperty<@NonNull ASTFImportFileModel, @Nullable Integer> getClusterIdProperty() {
        return new PropertyOnObservable<ASTFImportFileModel, Integer>(Integer.class){

            protected @NonNull WritableValue<@Nullable Integer> getObservable(@NonNull ASTFImportFileModel source) {
                return (WritableValue)ASTFAddFileViewModel.this.clusterIdObservables.computeIfAbsent((Object)source, s -> new WritableValue((Object)s.getClusterId(), Integer.class));
            }

            protected void setProperty(@NonNull ASTFImportFileModel source, @Nullable Integer modelValue) {
                super.setProperty((Object)source, (Object)modelValue);
                source.setClusterId(modelValue);
            }
        };
    }

    public @NonNull IValueProperty<@NonNull ASTFImportFileModel, @Nullable Integer> getCoreIdProperty() {
        return new PropertyOnObservable<ASTFImportFileModel, Integer>(Integer.class){

            protected @NonNull WritableValue<@Nullable Integer> getObservable(@NonNull ASTFImportFileModel source) {
                return (WritableValue)ASTFAddFileViewModel.this.coreIdObservables.computeIfAbsent((Object)source, s -> new WritableValue((Object)s.getCoreId(), Integer.class));
            }

            protected void setProperty(@NonNull ASTFImportFileModel source, @Nullable Integer modelValue) {
                super.setProperty((Object)source, (Object)modelValue);
                source.setCoreId(modelValue);
            }
        };
    }

    public void resetAllFileClusterCoreValues() {
        for (ASTFImportFileModel entry : this.getPropertyAllItems()) {
            if (((Boolean)this.getMultiCoreMode().getValue()).booleanValue()) {
                entry.updateClusterCoreValuesFromFilename();
                this.getClusterIdProperty().setValue((Object)entry, (Object)entry.getClusterId());
                this.getCoreIdProperty().setValue((Object)entry, (Object)entry.getCoreId());
                continue;
            }
            entry.setClusterId(0);
            entry.setCoreId(0);
            this.getClusterIdProperty().setValue((Object)entry, (Object)0);
            this.getCoreIdProperty().setValue((Object)entry, (Object)0);
        }
    }

    public @NonNull WritableList<@NonNull ASTFImportFileModel> getPropertySelectedASTFFiles() {
        return this.observableSelectedFiles;
    }

    public @NonNull IObservableValue<@NonNull ASTFFileActions> getASTFFileActionMode() {
        return this.observableFileActionMode;
    }

    public @NonNull IObservableValue<@NonNull Boolean> getMultiCoreMode() {
        return this.multiCoreMode;
    }

    public @NonNull ValidationStatusProvider getValidationStatusProvider() {
        return new MultiValidator(){

            protected IStatus validate() {
                if (!ASTFAddFileViewModel.this.validateClusterCoreIdsNonNegative()) {
                    return ValidationStatus.error((String)Messages.ImportASTFFile_ClusterAndCoresNonNegative);
                }
                if (!((Boolean)ASTFAddFileViewModel.this.observableValidateFilesPresent.getValue()).booleanValue()) {
                    return ValidationStatus.error((String)Messages.ImportASTF_AtleastOne_ASTF_file);
                }
                if (!((Boolean)ASTFAddFileViewModel.this.observableValidateClustersAndCoresSet.getValue()).booleanValue()) {
                    return ValidationStatus.error((String)Messages.ImportASTF_ClustersAndCoresNotSet);
                }
                return ValidationStatus.ok();
            }
        };
    }

    public @NonNull IObservableValue<@NonNull Boolean> canEnableRemoveButton() {
        return ComputedValue.create(() -> !this.observableSelectedFiles.isEmpty());
    }

    public @NonNull IObservableValue<@NonNull Boolean> canEnableUpDownButton() {
        return ComputedValue.create(() -> {
            if (((Boolean)this.multiCoreMode.getValue()).booleanValue()) {
                return Boolean.FALSE;
            }
            return !this.observableSelectedFiles.isEmpty() && this.observableSelectedFiles.size() == 1;
        });
    }

    public @NonNull IObservableValue<@NonNull Boolean> clustersAndCoreValuesSet() {
        return this.observableValidateClustersAndCoresSet;
    }

    public @NonNull WritableList<@NonNull ASTFImportFileModel> getAstfFilesFromDialogList() {
        return this.observableAstfFilesFromDialogList;
    }

    public boolean validateClusterCoreIdsNonNegative() {
        boolean clusterIdsNonNegative = this.clusterIdObservables.values().stream().map(AbstractObservableValue::getValue).allMatch(id -> id == null || id >= 0);
        boolean coreIdsNonNegative = this.coreIdObservables.values().stream().map(AbstractObservableValue::getValue).allMatch(id -> id == null || id >= 0);
        return clusterIdsNonNegative && coreIdsNonNegative;
    }

    public void addFilesFromDialog(@NonNull List<@NonNull ASTFImportFileModel> astfFiles) {
        HashSet<ASTFImportFileModel> uniqueListOfFiles = new HashSet<ASTFImportFileModel>(astfFiles);
        this.observableAstfFilesFromDialogList.clear();
        this.observableAstfFilesFromDialogList.addAll(0, uniqueListOfFiles);
    }

    public void setFileActionMode(@NonNull ASTFFileActions mode) {
        this.observableFileActionMode.setValue((Object)mode);
    }

    public void removeFileFromClusterAndCoreIdCaches(ASTFImportFileModel file) {
        this.clusterIdObservables.remove((Object)file);
        this.coreIdObservables.remove((Object)file);
    }

    public static enum ASTFFileActions {
        ADD,
        REMOVE,
        UP,
        DOWN,
        NONE;

    }
}

