/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.wizard.import_astf;

import com.arm.streamline.application.preferences.StreamlinePreferences;
import com.arm.streamline.astf.ASTFClusterInfo;
import com.arm.streamline.astf.xml.ASTFXmlUtility;
import com.arm.streamline.common.preferences.CommonPreferences;
import com.arm.streamline.databrowser.DocumentScanner;
import com.arm.streamline.widget.Error;
import com.arm.streamline.wizard.import_astf.ASTFAddFileWizardPage;
import com.arm.streamline.wizard.import_astf.ASTFAdditionalFilesWizardPage;
import com.arm.streamline.wizard.import_astf.ASTFCaptureFolderPage;
import com.arm.streamline.wizard.import_astf.Messages;
import com.arm.streamline.wizard.import_astf.viewmodel.ASTFAddFileViewModel;
import com.arm.streamline.wizard.import_astf.viewmodel.ASTFAdditionalFilesViewModel;
import com.arm.streamline.wizard.import_astf.viewmodel.ASTFCaptureViewModel;
import com.arm.streamline.wizard.import_astf.viewmodel.ASTFImportFileModel;
import com.arm.streamline.wizard.import_astf.viewmodel.ASTFImportUtility;
import com.arm.utils.NullChecking;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class ImportASTFWizard
extends Wizard
implements IImportWizard {
    private final @NonNull ASTFAddFileViewModel addFilesViewModel;
    private final @NonNull ASTFAdditionalFilesViewModel additionalFilesViewModel;
    private final @NonNull ASTFCaptureViewModel captureNameViewModel;
    private final @NonNull File path = new File(CommonPreferences.getLastSavePath());
    private final int TOTAL_PAGES = 3;

    public ImportASTFWizard() {
        this.addFilesViewModel = new ASTFAddFileViewModel();
        this.additionalFilesViewModel = new ASTFAdditionalFilesViewModel();
        File astfCaptureFolder = new File(this.path, CommonPreferences.chooseUniqueName((File)this.path, (String)((String)NullChecking.neverNull((Object)(CommonPreferences.getLastCaptureName() + ".apc")))));
        this.captureNameViewModel = new ASTFCaptureViewModel(astfCaptureFolder);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.addPage((IWizardPage)new ASTFAddFileWizardPage(this.addFilesViewModel, 1, 3));
        this.addPage((IWizardPage)new ASTFAdditionalFilesWizardPage(this.additionalFilesViewModel, 2, 3));
        this.addPage((IWizardPage)new ASTFCaptureFolderPage(this.captureNameViewModel, 3, 3));
        assert (3 == this.getPageCount()) : " TOTAL_PAGES doesn't match Page Count";
    }

    public String getWindowTitle() {
        return Messages.ImportASTF_ASTF_Title;
    }

    public boolean performFinish() {
        block15: {
            String astfCaptureFolder = (String)this.captureNameViewModel.getObservableCapturePath().getValue();
            try {
                Files.createDirectories(Paths.get(astfCaptureFolder, new String[0]), new FileAttribute[0]);
                File astfCaptureFolderFile = new File(astfCaptureFolder);
                File astfXmlFile = new File(astfCaptureFolder, "astf-trace.xml");
                if (astfXmlFile.createNewFile()) {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (FileOutputStream stream = new FileOutputStream(astfXmlFile);){
                        @NonNull ArrayList<@NonNull ASTFImportFileModel> fileModels = new ArrayList<ASTFImportFileModel>((Collection<ASTFImportFileModel>)this.addFilesViewModel.getPropertyAllItems());
                        if (((Boolean)this.addFilesViewModel.getMultiCoreMode().getValue()).booleanValue()) {
                            Collections.sort(fileModels, Comparator.comparing(ASTFImportFileModel::getClusterId, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(ASTFImportFileModel::getCoreId, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(ASTFImportFileModel::getFileName, Comparator.nullsLast(Comparator.naturalOrder())));
                        }
                        List<ASTFClusterInfo> clusterInfos = ASTFImportUtility.getClusterInfos(fileModels);
                        String pidTidMapPath = (String)this.additionalFilesViewModel.getObservablePidTidMapPath().getValue();
                        ASTFXmlUtility.save(stream, new Date().getTime(), astfCaptureFolderFile.getName(), clusterInfos, pidTidMapPath);
                        File parentFile = this.captureNameViewModel.getParentCaptureFile();
                        if (parentFile != null) {
                            CommonPreferences.setLastSavePath((String)parentFile.getAbsolutePath());
                            List<File> dataLocations = StreamlinePreferences.getDataLocations();
                            if (!dataLocations.contains(parentFile)) {
                                DocumentScanner.INSTANCE.addToWatchSet(parentFile);
                            }
                        }
                        break block15;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                Error.show(MessageFormat.format(Messages.ImportASTF_Failed_To_Create_ASTF_XML, astfXmlFile.getAbsolutePath()), true);
                return false;
            }
            catch (IOException e) {
                Error.show(e.getMessage(), e, true);
                return false;
            }
        }
        return true;
    }
}

