/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.wizard.import_astf;

import com.arm.streamline.common.utility.PathChoice;
import com.arm.streamline.wizard.import_astf.Messages;
import com.arm.streamline.wizard.import_astf.viewmodel.ASTFCaptureViewModel;
import com.arm.utils.NullChecking;
import java.text.MessageFormat;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public final class ASTFCaptureFolderPage
extends WizardPage
implements IPageChangedListener {
    private Text captureNameTxt;
    private Button browseButton;
    private @NonNull ASTFCaptureViewModel viewModel;

    public ASTFCaptureFolderPage(@NonNull ASTFCaptureViewModel viewModel, int currentPageNumber, int totalPages) {
        super("", MessageFormat.format(Messages.ImportASTFWizard_Add_Capture_Title, currentPageNumber, totalPages), null);
        this.setDescription(Messages.ImportASTFOutputWizard_Description);
        this.viewModel = viewModel;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(composite, 0);
        label.setText(Messages.ImportASTFCapture_Name);
        label.setToolTipText(Messages.ImportASTFCapture_NameTooltip);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)label);
        this.captureNameTxt = new Text(composite, 0);
        assert (this.captureNameTxt != null);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.captureNameTxt);
        this.captureNameTxt.setToolTipText(Messages.ImportASTFCapture_NameHelperText);
        this.browseButton = new Button(composite, 8);
        assert (this.browseButton != null);
        this.browseButton.setText(Messages.ImportASTFWizard_Browse_button);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)this.browseButton);
        this.initDataBindings();
        IWizardContainer container = this.getWizard().getContainer();
        assert (container instanceof WizardDialog);
        ((WizardDialog)container).addPageChangedListener((IPageChangedListener)this);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        @NonNull ISWTObservableValue observeText = WidgetProperties.text((int)24).observe((Widget)NullChecking.neverNull((Object)this.captureNameTxt));
        bindingContext.bindValue((IObservableValue)observeText, this.viewModel.getObservableCapturePath());
        bindingContext.addValidationStatusProvider(this.viewModel.getValidationStatusProvider());
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ASTFCaptureFolderPage.this.browseForCaptureFolder();
            }
        });
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)bindingContext);
        return bindingContext;
    }

    public void pageChanged(PageChangedEvent event) {
        if (event.getSelectedPage() == this && (this.captureNameTxt.getText() == null || this.captureNameTxt.getText().isEmpty())) {
            this.captureNameTxt.setText(this.viewModel.getSuggestedCaptureFolder().getAbsolutePath());
        }
    }

    private void browseForCaptureFolder() {
        String chooseCaptureSavePath = PathChoice.chooseCaptureSavePath();
        if (chooseCaptureSavePath != null && !chooseCaptureSavePath.isEmpty()) {
            this.captureNameTxt.setText(chooseCaptureSavePath);
        }
    }
}

