/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.wizard.import_astf;

import com.arm.streamline.wizard.import_astf.Messages;
import com.arm.streamline.wizard.import_astf.viewmodel.ASTFAdditionalFilesViewModel;
import com.arm.utils.NullChecking;
import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public final class ASTFAdditionalFilesWizardPage
extends WizardPage {
    private @NonNull ASTFAdditionalFilesViewModel viewModel;
    private FileDialog openFiles;
    private Text pidTidMapPath;
    private Button pidTidMapBrowseButton;

    public ASTFAdditionalFilesWizardPage(@NonNull ASTFAdditionalFilesViewModel viewModel, int currentPageNumber, int totalPages) {
        super("", MessageFormat.format(Messages.ImportASTFWIzard_Additional_Files_Title, currentPageNumber, totalPages), null);
        this.setDescription(Messages.ImportASTFWizard_Additional_Files_Description);
        this.viewModel = viewModel;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createFileDialog();
        this.createPidTidMapGroup(composite);
    }

    private void createFileDialog() {
        this.openFiles = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
    }

    private void createPidTidMapGroup(@NonNull Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(Messages.ImportASTFCapture_PidTidMap_Label);
        label.setToolTipText(Messages.ImportASTFCapture_PidTidMap_ToolTip);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)label);
        this.pidTidMapPath = new Text(composite, 0);
        assert (this.pidTidMapPath != null);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.pidTidMapPath);
        this.pidTidMapPath.setToolTipText(Messages.ImportASTFCapture_PidTidMap_ToolTip);
        this.pidTidMapBrowseButton = new Button(composite, 8);
        assert (this.pidTidMapBrowseButton != null);
        this.pidTidMapBrowseButton.setText(Messages.ImportASTFWizard_Browse_button);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)this.pidTidMapBrowseButton);
        this.initPidTidMapDataBindings();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void initPidTidMapDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        @NonNull ISWTObservableValue observeText = WidgetProperties.text((int)24).observe((Widget)NullChecking.neverNull((Object)this.pidTidMapPath));
        bindingContext.bindValue((IObservableValue)observeText, this.viewModel.getObservablePidTidMapPath());
        bindingContext.addValidationStatusProvider(this.viewModel.getValidationStatusProvider());
        this.pidTidMapBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ASTFAdditionalFilesWizardPage.this.openFiles.open() != null) {
                    String filterPath = ASTFAdditionalFilesWizardPage.this.openFiles.getFilterPath();
                    String fileName = ASTFAdditionalFilesWizardPage.this.openFiles.getFileName();
                    if (!fileName.isEmpty()) {
                        File file = new File(filterPath, fileName);
                        ASTFAdditionalFilesWizardPage.this.pidTidMapPath.setText(file.getAbsolutePath());
                    }
                }
            }
        });
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)bindingContext);
    }
}

