/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.outline;

import com.arm.streamline.common.utility.WorkspaceUtils;
import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.jni.apcdbgen.proto.IColumnDescriptor;
import com.arm.streamline.jni.apcdbgen.proto.ISampleCounterColumnAccessorFactory;
import com.arm.streamline.utility.text.TextDrawing;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.Fonts;
import com.arm.streamline.widget.outline.BoxCell;
import com.arm.streamline.widget.outline.Column;
import com.arm.streamline.widget.outline.ICell;
import com.arm.streamline.widget.outline.Outline;
import com.arm.streamline.widget.outline.Row;
import com.arm.utils.collections.Pair;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class PercentageCell<C extends Column<C>>
implements ICell<C> {
    private static int textSpace;
    private int mMinimumBarWidth;
    private boolean mWholeNumbersOnly;
    private boolean mpercentageOnly;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IColumnDescriptor.ColourPreference colourPreference;
    private final @Nullable Integer userRGB;

    public static int getMinimumContentWidth(Font font, boolean wholeNumbersOnly) {
        return FontInfo.get((Font)font).getExtent((String)NumberUtils.formatPercentage((double)99.999, (boolean)wholeNumbersOnly)).x + 8;
    }

    public PercentageCell(boolean wholeNumbersOnly, boolean percentageOnly, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IColumnDescriptor.ColourPreference colourPreference, @Nullable Integer userRGB) {
        this(100, wholeNumbersOnly, percentageOnly, colourPreference, userRGB);
    }

    public PercentageCell(int minimumBarWidth, boolean wholeNumbersOnly, boolean percentageOnly, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IColumnDescriptor.ColourPreference colourPreference, @Nullable Integer userRGB) {
        this.mMinimumBarWidth = minimumBarWidth;
        this.mWholeNumbersOnly = wholeNumbersOnly;
        this.mpercentageOnly = percentageOnly;
        this.colourPreference = colourPreference;
        this.userRGB = userRGB;
    }

    @Override
    public int compare(C column, Row<C> one, Row<C> two) {
        int result;
        int n = result = this.mpercentageOnly ? 0 : Long.compare(this.getValue(one, column), this.getValue(two, column));
        if (result == 0) {
            result = Double.compare(this.getPercentage(one, column), this.getPercentage(two, column));
        }
        return result;
    }

    @Override
    public void drawCell(GC gc, Rectangle bounds, Row<C> row, C column, boolean selected, boolean active) {
        if (!this.mpercentageOnly) {
            // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable ISampleCounterColumnAccessorFactory.PercentAndLong percentageAndValue = this.getPercentAndValue(row, column);
            long value = percentageAndValue != null ? percentageAndValue.value() : 0L;
            double percentage = percentageAndValue != null ? percentageAndValue.percent() : -1.0;
            PercentageCell.drawValueAndPercentage(gc, Fonts.getNormal(), bounds, value, percentage, this.mWholeNumbersOnly, selected, active, this.colourPreference, this.userRGB);
        } else {
            PercentageCell.drawPercentage(gc, Fonts.getNormal(), bounds, this.getPercentage(row, column), this.mWholeNumbersOnly, selected, active, this.colourPreference, this.userRGB);
        }
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ISampleCounterColumnAccessorFactory.PercentAndLong getPercentAndValue(@NonNull Row<C> row, @NonNull C column) {
        double percent = this.getPercentage(row, column);
        return percent >= 0.0 ? new ISampleCounterColumnAccessorFactory.PercentAndLong(this.getValue(row, column), percent) : null;
    }

    public long getValue(@NonNull Row<C> row, @NonNull C column) {
        return row.getDataAsLong(column);
    }

    @Override
    public int getMinimumContentWidth() {
        return WorkspaceUtils.isHeadless() ? 0 : PercentageCell.getMinimumContentWidth(Fonts.getNormal(), this.mWholeNumbersOnly);
    }

    public double getPercentage(@NonNull Row<C> row, @NonNull C column) {
        return row.getDataAsDouble(column);
    }

    @Override
    public Point getPreferredSize(Row<C> row, C column) {
        Font font = Fonts.getNormal();
        Point size = FontInfo.get(font).getExtent(NumberUtils.formatPercentage((double)99.999, (boolean)this.mWholeNumbersOnly));
        size.x += this.mMinimumBarWidth + 12;
        size.y += 2;
        return size;
    }

    @Override
    public String getToolTipText(Outline<C> outline, Point where, Row<C> row, C column) {
        return row.getToolTipText(column);
    }

    public static void drawValueAndPercentage(GC gc, Font font, Rectangle bounds, long sample, double percentage, boolean wholeNumbersOnly, boolean selected, boolean active, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IColumnDescriptor.ColourPreference colourPreference, @Nullable Integer userRGB) {
        if (percentage >= 0.0) {
            FontInfo fi;
            gc.setFont(font);
            if (percentage > 100.0) {
                percentage = 100.0;
            }
            if ((fi = FontInfo.get(font)).getWidth(NumberUtils.format((long)sample)) > textSpace) {
                textSpace = fi.getWidth(NumberUtils.format((long)sample));
            }
            int leftMargin = textSpace + 8;
            int percentWidth = bounds.width - leftMargin;
            int width = fi.getWidth(NumberUtils.formatPercentage((double)percentage, (boolean)wholeNumbersOnly));
            int textAvailable = Math.min(textSpace, bounds.width);
            gc.setForeground(Colors.getText(selected && active));
            if (textAvailable > 0) {
                TextDrawing.drawString(gc, TextDrawing.truncateString(font, NumberUtils.format((long)sample), textAvailable, 131072), bounds.x + 4 + textAvailable - 1, bounds.y + (bounds.height - fi.getHeight()) / 2, 131072);
            }
            if (percentWidth > 0 && percentWidth > width) {
                Pair<Color, Color> colours = PercentageCell.computeColours(colourPreference, userRGB);
                double p = percentage;
                BoxCell.drawBoxAround(gc, new Rectangle(bounds.x + leftMargin, bounds.y, percentWidth, bounds.height), innerBounds -> {
                    PercentageCell.drawPercentageBar(gc, font, fi, wholeNumbersOnly, p, innerBounds, (Color)pair.first, (Color)pair.second);
                    return true;
                });
            }
        }
    }

    private static @NonNull Pair<@NonNull Color, @NonNull Color> computeColours(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IColumnDescriptor.ColourPreference colourPreference, @Nullable Integer userRGB) {
        Color fromColour;
        return new Pair((Object)fromColour, (Object)(switch (colourPreference) {
            case IColumnDescriptor.ColourPreference.higher_is_better -> {
                fromColour = Colors.getWhite();
                yield Colors.getDarkGreen();
            }
            case IColumnDescriptor.ColourPreference.lower_is_better -> {
                fromColour = Colors.getWhite();
                yield Colors.getRed();
            }
            case IColumnDescriptor.ColourPreference.neutral -> {
                fromColour = Colors.getWhite();
                yield Colors.getDarkMagenta();
            }
            case IColumnDescriptor.ColourPreference.user_defined -> {
                if (userRGB != null) {
                    Color c = Colors.create(userRGB);
                    fromColour = Colors.isDark(c) ? Colors.getWhite() : Colors.getDarkGray();
                    yield c;
                }
                fromColour = Colors.getWhite();
                yield Colors.getDarkMagenta();
            }
            default -> throw new AssertionError(colourPreference);
        }));
    }

    public static void drawPercentage(GC gc, Font font, Rectangle bounds, double percentage, boolean wholeNumbersOnly, boolean selected, boolean active, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IColumnDescriptor.ColourPreference colourPreference, @Nullable Integer userRGB) {
        Pair<Color, Color> colours = PercentageCell.computeColours(colourPreference, userRGB);
        PercentageCell.drawPercentage(gc, font, bounds, percentage, wholeNumbersOnly, selected, active, (Color)colours.first, (Color)colours.second);
    }

    public static void drawPercentage(GC gc, Font font, Rectangle bounds, double percentage, boolean wholeNumbersOnly, boolean selected, boolean active, @NonNull Color fromColour, @NonNull Color toColour) {
        if (percentage >= 0.0) {
            gc.setFont(font);
            if (percentage > 100.0) {
                percentage = 100.0;
            }
            FontInfo fi = FontInfo.get(font);
            int width = fi.getWidth(NumberUtils.formatPercentage((double)percentage, (boolean)wholeNumbersOnly));
            if (bounds.width > 0 && bounds.width > width) {
                double p = percentage;
                BoxCell.drawBorderAround(bounds, innerBounds -> {
                    gc.setForeground(Colors.getText(selected && active));
                    PercentageCell.drawPercentageBar(gc, font, fi, wholeNumbersOnly, p, innerBounds, fromColour, toColour);
                });
            }
        }
    }

    private static void drawPercentageBar(GC gc, Font font, FontInfo fi, boolean wholeNumbersOnly, double percentage, @NonNull Rectangle innerBounds, @NonNull Color fromColour, @NonNull Color toColour) {
        int left = innerBounds.x;
        int top = innerBounds.y;
        int width = innerBounds.width;
        int height = innerBounds.height;
        int textWidth = width - 8;
        if (width > 0 && height > 0) {
            Color backgroundColour = Colors.blend(fromColour, toColour, (int)percentage);
            gc.setBackground(backgroundColour);
            gc.fillRectangle(left, top, (int)((double)width * (percentage / 100.0)), height);
            if (textWidth > 0) {
                String truncateString = TextDrawing.truncateString(font, NumberUtils.formatPercentage((double)percentage, (boolean)wholeNumbersOnly), textWidth, 131072);
                int realTextWidth = fi.getWidth(truncateString);
                int textMargin = (width - realTextWidth) / 2 + realTextWidth;
                assert (realTextWidth <= textWidth);
                TextDrawing.drawString(gc, truncateString, left + textMargin, top + (height - fi.getHeight()) / 2, 131072);
            }
        }
    }
}

