/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.outline;

import com.arm.streamline.common.utility.WorkspaceUtils;
import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.jni.apcdbgen.proto.IColumnDescriptor;
import com.arm.streamline.utility.text.TextDrawing;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.Fonts;
import com.arm.streamline.widget.outline.BoxCell;
import com.arm.streamline.widget.outline.Column;
import com.arm.streamline.widget.outline.ICell;
import com.arm.streamline.widget.outline.Outline;
import com.arm.streamline.widget.outline.Row;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class MpkiCell<C extends Column<C>>
implements ICell<C> {
    private static int textSpace;
    private static final int NUM_DIGITS = 2;
    private int mMinimumBarWidth;
    private boolean mWholeNumbersOnly;
    private boolean mNumberAndScale;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IColumnDescriptor.ColourPreference colourPreference;
    private final @Nullable Integer userRGB;

    public static int getMinimumContentWidth(Font font, boolean wholeNumbersOnly) {
        return FontInfo.get((Font)font).getExtent((String)NumberUtils.prettyFormat((double)999.999, (int)2, (boolean)wholeNumbersOnly)).x + 8;
    }

    public MpkiCell(boolean wholeNumbersOnly, boolean numberAndScale, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IColumnDescriptor.ColourPreference colourPreference, @Nullable Integer userRGB) {
        this(100, wholeNumbersOnly, numberAndScale, colourPreference, userRGB);
    }

    public MpkiCell(int minimumBarWidth, boolean wholeNumbersOnly, boolean numberAndScale, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IColumnDescriptor.ColourPreference colourPreference, @Nullable Integer userRGB) {
        this.mMinimumBarWidth = minimumBarWidth;
        this.mWholeNumbersOnly = wholeNumbersOnly;
        this.mNumberAndScale = numberAndScale;
        this.colourPreference = colourPreference;
        this.userRGB = userRGB;
    }

    @Override
    public int compare(C column, Row<C> one, Row<C> two) {
        double p2;
        double p1 = this.getMPKI(one, column);
        if (p1 < (p2 = this.getMPKI(two, column))) {
            return -1;
        }
        if (p1 > p2) {
            return 1;
        }
        return 0;
    }

    @Override
    public void drawCell(GC gc, Rectangle bounds, Row<C> row, C column, boolean selected, boolean active) {
        if (this.mNumberAndScale) {
            MpkiCell.drawValueAndScale(gc, Fonts.getNormal(), bounds, this.getMPKI(row, column), this.mWholeNumbersOnly, selected, active, this.colourPreference, this.userRGB);
        } else {
            MpkiCell.drawScale(gc, Fonts.getNormal(), bounds, this.getMPKI(row, column), this.mWholeNumbersOnly, selected, active, this.colourPreference, this.userRGB);
        }
    }

    @Override
    public int getMinimumContentWidth() {
        return WorkspaceUtils.isHeadless() ? 0 : MpkiCell.getMinimumContentWidth(Fonts.getNormal(), this.mWholeNumbersOnly);
    }

    public double getMPKI(@NonNull Row<C> row, @NonNull C column) {
        return row.getDataAsDouble(column);
    }

    @Override
    public Point getPreferredSize(Row<C> row, C column) {
        Font font = Fonts.getNormal();
        String formatted = NumberUtils.format((double)999.99, (int)2, (boolean)this.mWholeNumbersOnly);
        Point size = FontInfo.get(font).getExtent(formatted);
        size.x += this.mMinimumBarWidth + 12;
        size.y += 2;
        return size;
    }

    @Override
    public String getToolTipText(Outline<C> outline, Point where, Row<C> row, C column) {
        return row.getToolTipText(column);
    }

    public static void drawValueAndScale(GC gc, Font font, Rectangle bounds, double mpki, boolean wholeNumbersOnly, boolean selected, boolean active, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IColumnDescriptor.ColourPreference colourPreference, @Nullable Integer userRGB) {
        if (mpki >= 0.0) {
            gc.setFont(font);
            String formatted = NumberUtils.format((double)mpki, (int)2, (boolean)wholeNumbersOnly);
            FontInfo fi = FontInfo.get(font);
            int width = fi.getWidth(formatted);
            textSpace = Math.max(textSpace, width);
            int leftMargin = textSpace + 8;
            int percentWidth = bounds.width - leftMargin;
            int textAvailable = Math.min(textSpace, bounds.width);
            gc.setForeground(Colors.getText(selected && active));
            if (textAvailable > 0) {
                TextDrawing.drawString(gc, TextDrawing.truncateString(font, formatted, textAvailable, 131072), bounds.x + 4 + textAvailable - 1, bounds.y + (bounds.height - fi.getHeight()) / 2, 131072);
            }
            if (percentWidth > 0 && percentWidth > width) {
                BoxCell.drawBoxAround(gc, new Rectangle(bounds.x + leftMargin, bounds.y, percentWidth, bounds.height), innerBounds -> {
                    MpkiCell.drawScaleBar(gc, font, fi, wholeNumbersOnly, mpki, innerBounds, textAvailable <= 0, colourPreference, userRGB);
                    return true;
                });
            }
        }
    }

    public static void drawScale(GC gc, Font font, Rectangle bounds, double mpki, boolean wholeNumbersOnly, boolean selected, boolean active, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IColumnDescriptor.ColourPreference colourPreference, @Nullable Integer userRGB) {
        if (mpki >= 0.0) {
            gc.setFont(font);
            String formatted = NumberUtils.format((double)mpki, (int)2, (boolean)wholeNumbersOnly);
            FontInfo fi = FontInfo.get(font);
            int width = fi.getWidth(formatted);
            if (bounds.width > 0 && bounds.width > width) {
                BoxCell.drawBorderAround(bounds, innerBounds -> {
                    gc.setForeground(Colors.getText(selected && active));
                    MpkiCell.drawScaleBar(gc, font, fi, wholeNumbersOnly, mpki, innerBounds, true, colourPreference, userRGB);
                });
            }
        }
    }

    private static void drawScaleBar(GC gc, Font font, FontInfo fi, boolean wholeNumbersOnly, double mpki, @NonNull Rectangle innerBounds, boolean withLabel, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IColumnDescriptor.ColourPreference colourPreference, @Nullable Integer userRGB) {
        Color fromColour;
        int left = innerBounds.x;
        int top = innerBounds.y;
        int width = innerBounds.width;
        int height = innerBounds.height;
        int textWidth = width - 8;
        Color toColour = switch (colourPreference) {
            case IColumnDescriptor.ColourPreference.higher_is_better -> {
                fromColour = Colors.getWhite();
                yield Colors.getDarkGreen();
            }
            case IColumnDescriptor.ColourPreference.lower_is_better -> {
                fromColour = Colors.getWhite();
                yield Colors.getRed();
            }
            case IColumnDescriptor.ColourPreference.neutral -> {
                fromColour = Colors.getWhite();
                yield Colors.getDarkMagenta();
            }
            case IColumnDescriptor.ColourPreference.user_defined -> {
                if (userRGB != null) {
                    Color c = Colors.create(userRGB);
                    fromColour = Colors.isDark(c) ? Colors.getWhite() : Colors.getDarkGray();
                    yield c;
                }
                fromColour = Colors.getWhite();
                yield Colors.getDarkMagenta();
            }
            default -> throw new AssertionError(colourPreference);
        };
        if (width > 0 && height > 0) {
            double scaled = Math.min(Math.max(mpki, 0.0), 1000.0);
            Color backgroundColour = Colors.blend(fromColour, toColour, (int)scaled);
            gc.setBackground(backgroundColour);
            gc.fillRectangle(left, top, (int)((double)width * (scaled / 1000.0)), height);
            if (withLabel && textWidth > 0) {
                String formatted = NumberUtils.format((double)mpki, (int)2, (boolean)wholeNumbersOnly);
                String truncateString = TextDrawing.truncateString(font, formatted, textWidth, 131072);
                int realTextWidth = fi.getWidth(truncateString);
                int textMargin = (width - realTextWidth) / 2 + realTextWidth;
                assert (realTextWidth <= textWidth);
                TextDrawing.drawString(gc, truncateString, left + textMargin, top + (height - fi.getHeight()) / 2, 131072);
            }
        }
    }
}

