/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.lightweight;

import com.arm.streamline.common.utility.Task;
import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.lightweight.Block;
import com.arm.streamline.widget.lightweight.DragTracker;
import com.arm.utils.NullChecking;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class BlockScrollBar
extends Block {
    private static final @NonNull Color TOP_FILL_COLOR = Colors.getWidgetBackground();
    private static final @NonNull Color BOTTOM_FILL_COLOR = Colors.darken(Colors.getWidgetBackground(), 15);
    private static final @NonNull Color DEFAULT_BACKGROUND = Colors.lighten(Colors.getWidgetBackground(), 20);
    private static final @NonNull Color DEFAULT_DISABLED_BACKGROUND = Colors.getWidgetBackground();
    public static final int SIZE = 17;
    private static final int ARROW_DEPTH = 5;
    private static final int GRIP_COUNT = 4;
    private static final int INITIAL_DELAY = 400;
    private static final int DELAY = 100;
    private List<IBlockScrollListener> mScrollListeners = new ArrayList<IBlockScrollListener>();
    private long mMaximum;
    private long mThumb;
    private long mValue;
    private long mIncrement = 1L;
    private boolean mHorizontal;
    protected boolean mUpLeftPressed;
    protected boolean mDownRightPressed;
    protected boolean mThumbPressed;
    private DragTracker mTracker;
    protected boolean mChangeByUser;
    private final @NonNull Color mDisabledBackground;

    public BlockScrollBar(boolean horizontal, @Nullable Color disabledBackground) {
        this.mHorizontal = horizontal;
        this.mDisabledBackground = (Color)NullChecking.neverNullOr((Object)disabledBackground, (Object)DEFAULT_DISABLED_BACKGROUND);
        this.setBackgroundColor(this.mDisabledBackground);
    }

    public final synchronized void addScrollListener(IBlockScrollListener listener) {
        this.mScrollListeners.add(listener);
    }

    public final long getIncrement() {
        return this.mIncrement;
    }

    public final long getMaximum() {
        return this.mMaximum;
    }

    @Override
    public final Point getMinimumSize(int widthHint, int heightHint) {
        return new Point(this.mHorizontal ? 34 : 17, this.mHorizontal ? 17 : 34);
    }

    @Override
    public final Point getPreferredSize(int widthHint, int heightHint) {
        Point size = this.getMinimumSize(widthHint, heightHint);
        if (this.mHorizontal) {
            if (widthHint > size.x) {
                size.x = widthHint;
            }
        } else if (heightHint > size.y) {
            size.y = heightHint;
        }
        return size;
    }

    public final long getThumb() {
        return this.mThumb;
    }

    public final long getValue() {
        return this.mValue;
    }

    public final boolean isHorizontal() {
        return this.mHorizontal;
    }

    public final boolean isTracking() {
        return this.mTracker != null;
    }

    public final boolean isVertical() {
        return !this.mHorizontal;
    }

    public final synchronized void removeScrollListener(IBlockScrollListener listener) {
        this.mScrollListeners.remove(listener);
    }

    public final void setIncrement(long increment) {
        if (increment < 1L) {
            increment = 1L;
        }
        this.mIncrement = increment;
    }

    public final void setMaximum(long maximum) {
        if (maximum < 0L) {
            maximum = 0L;
        }
        if (this.mMaximum != maximum) {
            long maxValue;
            this.mMaximum = maximum;
            if (this.mThumb > this.mMaximum) {
                this.mThumb = this.mMaximum;
            }
            if (this.mValue > (maxValue = this.mMaximum - this.mThumb)) {
                this.mValue = maxValue;
                this.notifyOfScroll();
            }
            this.repaint();
        }
    }

    public final void setThumb(long thumb) {
        if (thumb < 0L) {
            thumb = 0L;
        } else if (thumb > this.mMaximum) {
            thumb = this.mMaximum;
        }
        if (this.mThumb != thumb) {
            this.mThumb = thumb;
            long maxValue = this.mMaximum - this.mThumb;
            if (this.mValue > maxValue) {
                this.mValue = maxValue;
                this.notifyOfScroll();
            }
            this.repaint();
        }
    }

    public final void setValue(long value) {
        if (value < 0L) {
            value = 0L;
        } else {
            long maxValue = this.mMaximum - this.mThumb;
            if (value > maxValue) {
                value = maxValue;
            }
        }
        if (this.mValue != value) {
            this.mValue = value;
            this.notifyOfScroll();
            this.repaint();
        }
    }

    protected final Rectangle getIncrementButtonBounds(boolean upLeft) {
        int y;
        int x;
        int size = 15;
        if (this.mHorizontal) {
            x = upLeft ? 1 : this.getWidth() - size - 1;
            y = this.getHeight() - size - 1;
        } else {
            x = this.getWidth() - size - 1;
            y = upLeft ? 1 : this.getHeight() - size - 1;
        }
        return new Rectangle(x, y, size, size);
    }

    protected final Rectangle getThumbBounds() {
        int x;
        int width;
        int height;
        int y;
        if (this.mMaximum == this.mThumb) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle upLeftBounds = this.getIncrementButtonBounds(true);
        Rectangle downRightBounds = this.getIncrementButtonBounds(false);
        int size = 15;
        int minThumbSize = 16;
        if (this.mHorizontal) {
            int left = upLeftBounds.x + upLeftBounds.width;
            y = this.getHeight() - size - 1;
            height = size;
            int space = downRightBounds.x - left;
            if (space > 0 && this.mMaximum > 0L) {
                if (space > minThumbSize) {
                    long range;
                    width = (int)((long)space * this.mThumb / this.mMaximum);
                    if (width < minThumbSize) {
                        width = minThumbSize;
                    }
                    x = left + ((range = this.mMaximum - this.mThumb) > 0L ? (int)((long)(space - width) * this.mValue / range) : 0);
                } else {
                    x = left;
                    width = space;
                }
            } else {
                x = left;
                width = 0;
            }
        } else {
            int top = upLeftBounds.y + upLeftBounds.height;
            x = this.getWidth() - size - 1;
            width = size;
            int space = downRightBounds.y - top;
            if (space > 0 && this.mMaximum > 0L) {
                if (space > minThumbSize) {
                    long range;
                    height = (int)((long)space * this.mThumb / this.mMaximum);
                    if (height < minThumbSize) {
                        height = minThumbSize;
                    }
                    y = top + ((range = this.mMaximum - this.mThumb) > 0L ? (int)((long)(space - height) * this.mValue / range) : 0);
                } else {
                    y = top;
                    height = space;
                }
            } else {
                y = top;
                height = 0;
            }
        }
        return new Rectangle(x, y, width, height);
    }

    protected final long getValueForLocation(Point where) {
        long range;
        if (this.mMaximum > 0L && (range = this.mMaximum - this.mThumb) > 0L) {
            Rectangle upLeftBounds = this.getIncrementButtonBounds(true);
            Rectangle downRightBounds = this.getIncrementButtonBounds(false);
            int minThumbSize = 16;
            if (this.mHorizontal) {
                int left = upLeftBounds.x + upLeftBounds.width;
                int space = downRightBounds.x - left;
                if (space > minThumbSize) {
                    long width = (long)space * this.mThumb / this.mMaximum;
                    if (width < (long)minThumbSize) {
                        width = minThumbSize;
                    }
                    return (long)(where.x - left) * range / ((long)space - width);
                }
            } else {
                int top = upLeftBounds.y + upLeftBounds.height;
                int space = downRightBounds.y - top;
                if (space > minThumbSize) {
                    long height = (long)space * this.mThumb / this.mMaximum;
                    if (height < (long)minThumbSize) {
                        height = minThumbSize;
                    }
                    return (long)(where.y - top) * range / ((long)space - height);
                }
            }
        }
        return 0L;
    }

    @Override
    protected final void mouseDown(Point where, int button, int stateMask, int count) {
        if (button == 1) {
            this.mTracker = this.getIncrementButtonBounds(true).contains(where) ? new IncrementButtonTracker(this, true) : (this.getIncrementButtonBounds(false).contains(where) ? new IncrementButtonTracker(this, false) : (this.getThumbBounds().contains(where) ? new ThumbTracker(this, where) : new GutterTracker(this, where)));
        }
    }

    @Override
    protected final void mouseDrag(Point where, int button, int stateMask) {
        super.mouseDrag(where, button, stateMask);
        if (this.mTracker != null) {
            this.mTracker.mouseDrag(where, stateMask);
        }
    }

    @Override
    protected final void mouseUp(Point where, int button, int stateMask, int count) {
        super.mouseUp(where, button, stateMask, count);
        if (this.mTracker != null) {
            this.mTracker.mouseUp(where, button, stateMask, count);
            this.mTracker = null;
        }
    }

    @Override
    protected final void paintSelf(GC gc) {
        if (this.mMaximum != this.mThumb) {
            this.setBackgroundColor(DEFAULT_BACKGROUND);
            super.paintSelf(gc);
            int savedAA = gc.getAntialias();
            gc.setAntialias(0);
            gc.setForeground(Colors.getDivider());
            Rectangle bounds = this.getLocalBounds();
            gc.drawRectangle(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
            gc.setAntialias(savedAA);
            this.drawThumb(gc);
            this.drawIncrementButton(gc, true);
            this.drawIncrementButton(gc, false);
        } else {
            this.setBackgroundColor(this.mDisabledBackground);
            super.paintSelf(gc);
            int savedAA = gc.getAntialias();
            gc.setAntialias(0);
            gc.setForeground(Colors.getDivider());
            Rectangle bounds = this.getLocalBounds();
            gc.drawRectangle(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
            gc.setAntialias(savedAA);
        }
    }

    private final void drawBox(GC gc, Rectangle bounds, boolean pressed) {
        int savedAA = gc.getAntialias();
        gc.setAntialias(0);
        gc.setForeground(pressed ? BOTTOM_FILL_COLOR : TOP_FILL_COLOR);
        gc.setBackground(pressed ? TOP_FILL_COLOR : BOTTOM_FILL_COLOR);
        gc.fillGradientRectangle(bounds.x + 1, bounds.y + 1, bounds.width - 2, bounds.height - 2, this.mHorizontal);
        gc.setForeground(Colors.darken(Colors.getWidgetBackground(), 20));
        gc.drawRectangle(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
        gc.setForeground(Colors.darken(Colors.getWidgetBackground(), 10));
        gc.drawLine(bounds.x, bounds.y, bounds.x, bounds.y);
        gc.drawLine(bounds.x + bounds.width - 1, bounds.y, bounds.x + bounds.width - 1, bounds.y);
        gc.drawLine(bounds.x, bounds.y + bounds.height - 1, bounds.x, bounds.y + bounds.height - 1);
        gc.drawLine(bounds.x + bounds.width - 1, bounds.y + bounds.height - 1, bounds.x + bounds.width - 1, bounds.y + bounds.height - 1);
        gc.setAntialias(savedAA);
    }

    private final void drawIncrementButton(GC gc, boolean upLeft) {
        Rectangle bounds = this.getIncrementButtonBounds(upLeft);
        this.drawBox(gc, bounds, upLeft ? this.mUpLeftPressed : this.mDownRightPressed);
        int savedAA = gc.getAntialias();
        gc.setAntialias(0);
        gc.setForeground(Colors.getBlack());
        if (this.mHorizontal) {
            int dir;
            int x = bounds.x + (bounds.width - 5) / 2;
            int y = bounds.y + bounds.height / 2;
            if (upLeft) {
                dir = 1;
            } else {
                x += 4;
                dir = -1;
            }
            int i = 0;
            while (i < 5) {
                gc.drawLine(x, y - i, x, y + i);
                x += dir;
                ++i;
            }
        } else {
            int dir;
            int x = bounds.x + bounds.width / 2;
            int y = bounds.y + (bounds.height - 5) / 2;
            if (upLeft) {
                dir = 1;
            } else {
                y += 4;
                dir = -1;
            }
            int i = 0;
            while (i < 5) {
                gc.drawLine(x - i, y, x + i, y);
                y += dir;
                ++i;
            }
        }
        gc.setAntialias(savedAA);
    }

    private final void drawThumb(GC gc) {
        Rectangle bounds = this.getThumbBounds();
        this.drawBox(gc, bounds, this.mThumbPressed);
        int savedAA = gc.getAntialias();
        gc.setAntialias(0);
        gc.setAlpha(128);
        if (this.mHorizontal) {
            int y1 = bounds.y + bounds.height / 2 - 4;
            int y2 = y1 + 8;
            int x = bounds.x + 1 + (bounds.width - 12) / 2;
            int min = bounds.x + 1;
            int max = bounds.x + bounds.width - 1;
            int i = 0;
            while (i < 4) {
                if (x >= min && x <= max) {
                    gc.setForeground(Colors.getBlack());
                    gc.drawLine(x, y1, x, y2);
                }
                if (++x >= min && x <= max) {
                    gc.setForeground(Colors.getWhite());
                    gc.drawLine(x, y1, x, y2);
                }
                x += 2;
                ++i;
            }
        } else {
            int x1 = bounds.x + bounds.width / 2 - 4;
            int x2 = x1 + 8;
            int y = bounds.y + 1 + (bounds.height - 12) / 2;
            int min = bounds.y + 1;
            int max = bounds.y + bounds.height - 1;
            int i = 0;
            while (i < 4) {
                if (y >= min && y <= max) {
                    gc.setForeground(Colors.getBlack());
                    gc.drawLine(x1, y, x2, y);
                }
                if (++y >= min && y <= max) {
                    gc.setForeground(Colors.getWhite());
                    gc.drawLine(x1, y, x2, y);
                }
                y += 2;
                ++i;
            }
        }
        gc.setAlpha(255);
        gc.setAntialias(savedAA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void notifyOfScroll() {
        IBlockScrollListener[] listeners;
        BlockScrollBar blockScrollBar = this;
        synchronized (blockScrollBar) {
            listeners = this.mScrollListeners.toArray(new IBlockScrollListener[this.mScrollListeners.size()]);
        }
        IBlockScrollListener[] iBlockScrollListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IBlockScrollListener listener = iBlockScrollListenerArray[n2];
            listener.scrollBarWasAdjusted(this, this.mChangeByUser);
            ++n2;
        }
    }

    private class GutterTracker
    extends DragTracker
    implements Runnable {
        private boolean mUpLeft;
        private Point mWhere;
        private boolean mDone;

        protected GutterTracker(Block block, Point where) {
            super(block);
            Rectangle bounds = BlockScrollBar.this.getThumbBounds();
            this.mUpLeft = BlockScrollBar.this.isHorizontal() ? where.x < bounds.x : where.y < bounds.y;
            this.mWhere = new Point(where.x, where.y);
            Task.scheduleOnUIThread((Runnable)this, null, (long)400L, (TimeUnit)TimeUnit.MILLISECONDS);
            this.adjust();
        }

        @Override
        public final void mouseDrag(Point where, int stateMask) {
            super.mouseDrag(where, stateMask);
            this.mWhere = new Point(where.x, where.y);
        }

        @Override
        public final void mouseUp(Point where, int button, int stateMask, int count) {
            super.mouseUp(where, button, stateMask, count);
            this.mDone = true;
        }

        @Override
        public final void run() {
            if (!this.mDone) {
                Task.scheduleOnUIThread((Runnable)this, null, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
                this.adjust();
            }
        }

        private final void adjust() {
            Rectangle bounds;
            if (BlockScrollBar.this.getLocalBounds().contains(this.mWhere) && !(bounds = BlockScrollBar.this.getThumbBounds()).contains(this.mWhere)) {
                boolean state;
                if (BlockScrollBar.this.isHorizontal()) {
                    state = this.mWhere.x < bounds.x;
                } else {
                    boolean bl = state = this.mWhere.y < bounds.y;
                }
                if (this.mUpLeft == state) {
                    BlockScrollBar.this.mChangeByUser = true;
                    long value = BlockScrollBar.this.getThumb();
                    BlockScrollBar.this.setValue(BlockScrollBar.this.getValue() + (this.mUpLeft ? -value : value));
                    BlockScrollBar.this.mChangeByUser = false;
                }
            }
        }
    }

    public static interface IBlockScrollListener {
        public void scrollBarWasAdjusted(BlockScrollBar var1, boolean var2);
    }

    private class IncrementButtonTracker
    extends DragTracker
    implements Runnable {
        private boolean mDone;
        private boolean mUpLeft;

        protected IncrementButtonTracker(Block block, boolean upLeft) {
            super(block);
            this.mUpLeft = upLeft;
            if (this.mUpLeft) {
                BlockScrollBar.this.mUpLeftPressed = true;
            } else {
                BlockScrollBar.this.mDownRightPressed = true;
            }
            Task.scheduleOnUIThread((Runnable)this, null, (long)400L, (TimeUnit)TimeUnit.MILLISECONDS);
            this.adjust();
            BlockScrollBar.this.repaint();
        }

        @Override
        public final void mouseDrag(Point where, int stateMask) {
            super.mouseDrag(where, stateMask);
            this.setPressed(BlockScrollBar.this.getIncrementButtonBounds(this.mUpLeft).contains(where));
        }

        @Override
        public final void mouseUp(Point where, int button, int stateMask, int count) {
            super.mouseUp(where, button, stateMask, count);
            this.mDone = true;
            this.setPressed(false);
        }

        @Override
        public final void run() {
            if (!this.mDone) {
                Task.scheduleOnUIThread((Runnable)this, null, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
                this.adjust();
            }
        }

        private final void adjust() {
            if (this.mUpLeft ? BlockScrollBar.this.mUpLeftPressed : BlockScrollBar.this.mDownRightPressed) {
                long increment = BlockScrollBar.this.getIncrement();
                BlockScrollBar.this.mChangeByUser = true;
                BlockScrollBar.this.setValue(BlockScrollBar.this.getValue() + (this.mUpLeft ? -increment : increment));
                BlockScrollBar.this.mChangeByUser = false;
            }
        }

        private final void setPressed(boolean pressed) {
            if ((this.mUpLeft ? BlockScrollBar.this.mUpLeftPressed : BlockScrollBar.this.mDownRightPressed) != pressed) {
                if (this.mUpLeft) {
                    BlockScrollBar.this.mUpLeftPressed = pressed;
                } else {
                    BlockScrollBar.this.mDownRightPressed = pressed;
                }
                BlockScrollBar.this.repaint();
            }
        }
    }

    private class ThumbTracker
    extends DragTracker
    implements Runnable {
        int mOffset;
        boolean updateInProgress;
        Point where;

        protected ThumbTracker(Block block, Point where) {
            super(block);
            this.updateInProgress = false;
            BlockScrollBar.this.mThumbPressed = true;
            Rectangle bounds = BlockScrollBar.this.getThumbBounds();
            this.mOffset = BlockScrollBar.this.isHorizontal() ? bounds.x - where.x : bounds.y - where.y;
            this.where = where;
            BlockScrollBar.this.repaint();
        }

        @Override
        public final void mouseDrag(Point where, int stateMask) {
            super.mouseDrag(where, stateMask);
            if (!this.updateInProgress) {
                this.updateInProgress = true;
                this.where = where;
                Task.scheduleOnUIThread((Runnable)this, null, (long)10L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        }

        @Override
        public final void mouseUp(Point where, int button, int stateMask, int count) {
            super.mouseUp(where, button, stateMask, count);
            BlockScrollBar.this.mThumbPressed = false;
            BlockScrollBar.this.repaint();
        }

        @Override
        public void run() {
            BlockScrollBar.this.mChangeByUser = true;
            BlockScrollBar.this.setValue(BlockScrollBar.this.getValueForLocation(new Point(BlockScrollBar.this.isHorizontal() ? this.where.x + this.mOffset : this.where.x, BlockScrollBar.this.isVertical() ? this.where.y + this.mOffset : this.where.y)));
            BlockScrollBar.this.mChangeByUser = false;
            this.updateInProgress = false;
        }
    }
}

