/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget;

import com.arm.streamline.common.utility.Task;
import com.arm.streamline.widget.IToolTipTracker;
import java.util.concurrent.TimeUnit;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class UpdatingToolTip
extends DefaultToolTip
implements MouseWheelListener,
MouseMoveListener,
MouseTrackListener,
DisposeListener,
MouseListener {
    private static final long SHOW_DELAY = 350L;
    private static final int HIDE_DELAY = 5000;
    private Point mMouseLocation;
    private IToolTipTracker mTracker;
    private boolean mShowing;
    private Task mTask;
    private Control mControl;

    public static UpdatingToolTip create(Control control, IToolTipTracker tracker) {
        return new UpdatingToolTip(control, tracker);
    }

    private UpdatingToolTip(Control control, IToolTipTracker tracker) {
        super(control, 1, false);
        this.mControl = control;
        this.mTracker = tracker;
        this.mControl.addMouseMoveListener((MouseMoveListener)this);
        this.mControl.addMouseTrackListener((MouseTrackListener)this);
        this.mControl.addDisposeListener((DisposeListener)this);
        this.mControl.addMouseListener((MouseListener)this);
        this.mControl.addMouseWheelListener((MouseWheelListener)this);
        this.setRespectDisplayBounds(false);
        this.setRespectMonitorBounds(true);
        this.setShift(new Point(0, 20));
        this.setHideDelay(5000);
        this.setPopupDelay(0);
    }

    public void mouseDoubleClick(MouseEvent event) {
    }

    public void mouseDown(MouseEvent event) {
    }

    public void mouseEnter(MouseEvent event) {
        this.mMouseLocation = new Point(event.x, event.y);
        this.update();
    }

    public void mouseExit(MouseEvent event) {
        this.mMouseLocation = null;
        this.update();
    }

    public void mouseHover(MouseEvent event) {
        this.mMouseLocation = new Point(event.x, event.y);
        this.update();
    }

    public void mouseMove(MouseEvent event) {
        this.mMouseLocation = new Point(event.x, event.y);
        this.update();
    }

    public void mouseScrolled(MouseEvent event) {
        this.mMouseLocation = new Point(event.x, event.y);
        this.update();
    }

    public void mouseUp(MouseEvent event) {
        if (event.button == 3) {
            this.show(null);
        }
    }

    public void update() {
        if (this.mMouseLocation != null) {
            this.show(this.mTracker.getToolTipForLocation(this.mMouseLocation));
        } else {
            this.show(null);
        }
    }

    public void widgetDisposed(DisposeEvent event) {
        this.mControl.removeMouseMoveListener((MouseMoveListener)this);
        this.mControl.removeMouseTrackListener((MouseTrackListener)this);
        this.mControl.removeMouseListener((MouseListener)this);
        this.mControl.removeMouseWheelListener((MouseWheelListener)this);
    }

    protected boolean setTextAndShow(String text, boolean force) {
        if (this.mControl.isDisposed() || this.mMouseLocation == null) {
            return false;
        }
        if (force || !this.mShowing) {
            super.setText(text);
            super.show(this.mMouseLocation);
            this.mShowing = true;
            return true;
        }
        return false;
    }

    protected boolean shouldCreateToolTip(Event event) {
        boolean retval = super.shouldCreateToolTip(event);
        if (retval) {
            retval = this.getText(event) != null;
        }
        return retval;
    }

    private void show(final String text) {
        if (this.mMouseLocation != null && text != null) {
            if (this.mShowing) {
                this.setTextAndShow(text, true);
            } else {
                if (this.mTask != null) {
                    this.mTask.cancel();
                }
                this.mTask = Task.scheduleOnUIThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        UpdatingToolTip.this.setTextAndShow(text, false);
                    }
                }, null, (long)350L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        } else {
            if (this.mTask != null) {
                this.mTask.cancel();
            }
            super.setText(null);
            this.mShowing = false;
        }
    }
}

