/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget;

import com.arm.streamline.application.StreamlineImages;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.utility.text.TextDrawing;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.SafeUpdate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class DropDownMenu
extends Canvas
implements PaintListener,
MouseListener,
MouseTrackListener,
DisposeListener,
MenuListener,
SelectionListener {
    private static final int MARGIN = 3;
    private static final int CORNER_RADIUS = 4;
    private static final int MENU_GAP = 2;
    private Map<Image, Image> mDisabledMenuImages = new HashMap<Image, Image>();
    protected boolean mDrawBorder;
    protected boolean mPressed;
    private boolean mEnabled = true;
    private Menu mMenu;
    private int mCurrentIndex = -1;
    private Set<IPopupMenuItemSelectionListener> mPopupMenuItemSelectionListeners = new HashSet<IPopupMenuItemSelectionListener>();

    public DropDownMenu(Composite parent) {
        super(parent, 0x20040000);
        this.addPaintListener(this);
        this.addMouseListener(this);
        this.addMouseTrackListener(this);
        this.addDisposeListener(this);
        this.mMenu = new Menu((Control)this);
        this.mMenu.addMenuListener((MenuListener)this);
    }

    public MenuItem addMenuItem(Image img, String title, Object data) {
        MenuItem item = new MenuItem(this.mMenu, 32);
        if (img != null) {
            item.setImage(img);
        }
        item.setText(title);
        if (data != null) {
            item.setData(data);
        }
        item.addSelectionListener((SelectionListener)this);
        return item;
    }

    public MenuItem addMenuItem(String title) {
        return this.addMenuItem(null, title, null);
    }

    public MenuItem addMenuItem(String title, Object data) {
        return this.addMenuItem(null, title, data);
    }

    public void addMenuSeparator() {
        new MenuItem(this.mMenu, 2).setData(null);
    }

    public synchronized void addPopupMenuItemSelectionListener(IPopupMenuItemSelectionListener listener) {
        this.mPopupMenuItemSelectionListeners.add(listener);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int margins = 6;
        int width = 0;
        int height = 0;
        GC gc = new GC((Drawable)this);
        gc.setFont(this.getFont());
        gc.setTextAntialias(1);
        MenuItem[] menuItemArray = this.mMenu.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item = menuItemArray[n2];
            int oneWidth = 0;
            Image img = item.getImage();
            if (img != null) {
                Rectangle bounds = img.getBounds();
                oneWidth = bounds.width + 3;
                if (height < bounds.height) {
                    height = bounds.height;
                }
            }
            Point extent = gc.stringExtent(item.getText());
            extent.x += oneWidth;
            if (width < extent.x) {
                width = extent.x;
            }
            if (height < extent.y) {
                height = extent.y;
            }
            ++n2;
        }
        gc.dispose();
        Point size = new Point(width, height);
        Rectangle bounds = StreamlinePlugin.getImage(StreamlineImages.MENU_DROP_ARROW).getBounds();
        size.x += 2 + bounds.width;
        if (size.y < bounds.height) {
            size.y = bounds.height;
        }
        size.x += margins;
        size.y += margins;
        return size;
    }

    public int getItemIndex(Object data) {
        MenuItem[] items = this.mMenu.getItems();
        int i = 0;
        while (i < items.length) {
            Object itemData = items[i].getData();
            if (data == null ? itemData == null : data.equals(itemData)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public MenuItem[] getMenuItems() {
        return this.mMenu.getItems();
    }

    public int getSelectedIndex() {
        return this.mCurrentIndex >= 0 && this.mCurrentIndex < this.mMenu.getItemCount() ? this.mCurrentIndex : -1;
    }

    public boolean isReallyEnabled() {
        return this.mEnabled;
    }

    public void menuHidden(MenuEvent menuEvent) {
        this.mPressed = false;
        this.mDrawBorder = false;
        SafeUpdate.redraw((Control)this);
    }

    public void menuShown(MenuEvent event) {
    }

    public void mouseDoubleClick(MouseEvent event) {
    }

    public void mouseDown(MouseEvent event) {
        if (this.mEnabled) {
            Rectangle bounds = this.getClientArea();
            Point where = this.toDisplay(0, bounds.y + bounds.height);
            if (!this.getMonitor().getClientArea().contains(where)) {
                where.y -= bounds.height;
            }
            this.mMenu.setLocation(where);
            this.mMenu.setVisible(true);
            this.mPressed = true;
            SafeUpdate.redraw((Control)this);
        }
    }

    public void mouseEnter(MouseEvent event) {
        this.mDrawBorder = true;
        SafeUpdate.redraw((Control)this);
    }

    public void mouseExit(MouseEvent event) {
        this.mDrawBorder = false;
        SafeUpdate.redraw((Control)this);
    }

    public void mouseHover(MouseEvent event) {
    }

    public void mouseUp(MouseEvent event) {
    }

    public void paintControl(PaintEvent event) {
        boolean enabled = this.mEnabled;
        GC gc = new GC(event.gc);
        Rectangle bounds = this.getClientArea();
        Color color = Colors.getWidgetBackground();
        gc.setBackground(color);
        gc.fillRectangle(bounds);
        int savedAA = gc.getAntialias();
        int savedTextAA = gc.getTextAntialias();
        gc.setAntialias(1);
        gc.setTextAntialias(1);
        if (this.mPressed || enabled && this.mDrawBorder) {
            Color lightColor = Colors.lighten(color, 15);
            Color darkColor = Colors.darken(color, 20);
            Color topColor = this.mPressed ? darkColor : lightColor;
            Color bottomColor = this.mPressed ? lightColor : darkColor;
            Pattern pattern = new Pattern(gc.getDevice(), (float)bounds.x, (float)bounds.y, (float)bounds.x, (float)(bounds.y + bounds.height - 1), topColor, bottomColor);
            gc.setBackgroundPattern(pattern);
            gc.fillRoundRectangle(bounds.x, bounds.y, bounds.width, bounds.height, 4, 4);
            pattern.dispose();
        } else {
            gc.setBackground(Colors.darken(color, 5));
            gc.fillRoundRectangle(bounds.x, bounds.y, bounds.width, bounds.height, 4, 4);
            gc.setForeground(Colors.darken(color, 10));
            gc.drawRoundRectangle(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1, 4, 4);
        }
        Image menuImage = StreamlinePlugin.getImage(StreamlineImages.MENU_DROP_ARROW);
        Rectangle menuImageBounds = menuImage.getBounds();
        int index = this.getSelectedIndex();
        if (index >= 0) {
            int left = bounds.x + 3;
            MenuItem item = this.mMenu.getItem(index);
            boolean itemEnabled = item.getEnabled();
            Image img = item.getImage();
            if (img != null) {
                Rectangle imgBounds = img.getBounds();
                gc.drawImage(enabled && itemEnabled ? img : this.getDisabledImage(img), left, bounds.y + (bounds.height - imgBounds.height) / 2);
                left += imgBounds.width + 3;
            }
            gc.setForeground(enabled && itemEnabled ? Colors.getWidgetForeground() : Colors.getWidgetNormalShadow());
            Font font = this.getFont();
            gc.setFont(font);
            String text = TextDrawing.truncateString(gc, item.getText(), bounds.width - (menuImageBounds.width + 2 + 6), 131072);
            TextDrawing.drawString(gc, text, left, bounds.y + (bounds.height - FontInfo.get(font).getHeight()) / 2, 16384);
        }
        gc.drawImage(enabled ? menuImage : this.getDisabledImage(menuImage), bounds.x + bounds.width - (menuImageBounds.width + 3), bounds.y + (bounds.height - menuImageBounds.height) / 2);
        if (this.mPressed || enabled && this.mDrawBorder) {
            gc.setForeground(Colors.darken(color, 30));
            gc.drawRoundRectangle(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1, 4, 4);
        }
        gc.setAntialias(savedAA);
        gc.setTextAntialias(savedTextAA);
    }

    public synchronized void removePopupMenuItemSelectionListener(IPopupMenuItemSelectionListener listener) {
        this.mPopupMenuItemSelectionListeners.remove(listener);
    }

    public void selectItemWithData(Object data) {
        int index = this.getItemIndex(data);
        if (index != -1) {
            this.setSelectedIndex(index);
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.mEnabled != enabled) {
            this.mEnabled = enabled;
            SafeUpdate.redraw((Control)this);
        }
    }

    public void setEnabledByItemIndex(int index, boolean enabled) {
        if (index >= 0 && index < this.mMenu.getItemCount()) {
            this.mMenu.getItem(index).setEnabled(enabled);
            SafeUpdate.redraw((Control)this);
        }
    }

    public void setEnabledByItemWithData(Object data, boolean enabled) {
        this.setEnabledByItemIndex(this.getItemIndex(data), enabled);
    }

    public void setSelectedIndex(int index) {
        if (index != this.mCurrentIndex && index >= 0 && index < this.mMenu.getItemCount()) {
            int old = this.getSelectedIndex();
            if (old >= 0) {
                this.mMenu.getItem(old).setSelection(false);
            }
            this.mCurrentIndex = index;
            this.mMenu.getItem(this.mCurrentIndex).setSelection(true);
            SafeUpdate.redraw((Control)this);
        }
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetDisposed(DisposeEvent event) {
        for (Image img : this.mDisabledMenuImages.values()) {
            img.dispose();
        }
        this.mDisabledMenuImages.clear();
        if (this.mMenu != null) {
            this.mMenu.dispose();
            this.mMenu = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void widgetSelected(SelectionEvent event) {
        MenuItem[] items = this.mMenu.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i] == event.widget) {
                IPopupMenuItemSelectionListener[] listeners;
                this.setSelectedIndex(i);
                DropDownMenu dropDownMenu = this;
                synchronized (dropDownMenu) {
                    listeners = this.mPopupMenuItemSelectionListeners.toArray(new IPopupMenuItemSelectionListener[this.mPopupMenuItemSelectionListeners.size()]);
                }
                Object data = items[i].getData();
                IPopupMenuItemSelectionListener[] iPopupMenuItemSelectionListenerArray = listeners;
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    IPopupMenuItemSelectionListener listener = iPopupMenuItemSelectionListenerArray[n2];
                    listener.popupMenuItemSelected(this, i, data);
                    ++n2;
                }
                break;
            }
            ++i;
        }
    }

    private final Image getDisabledImage(Image img) {
        Image image = this.mDisabledMenuImages.get(img);
        if (image == null) {
            image = new Image(img.getDevice(), img, 1);
            this.mDisabledMenuImages.put(img, image);
        }
        return image;
    }

    public static interface IPopupMenuItemSelectionListener {
        public void popupMenuItemSelected(DropDownMenu var1, int var2, Object var3);
    }
}

