/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.utility.RGBUtils;
import gnu.trove.map.hash.TIntObjectHashMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class Colors {
    private static final TIntObjectHashMap<Color> MAP = new TIntObjectHashMap();
    private static final @NonNull Color @NonNull [] CORE_COLORS;
    private static final @NonNull Color @NonNull [] CLUSTER_COLORS;

    static {
        int i = 1;
        while (i < 36) {
            Colors.getSystemColor(i);
            ++i;
        }
        CORE_COLORS = new Color[]{Colors.create(48, 97, 191), Colors.create(48, 191, 142), Colors.create(142, 48, 191), Colors.create(191, 118, 48), Colors.create(240, 230, 140), Colors.create(140, 230, 240), Colors.create(192, 0, 192), Colors.create(128, 128, 0)};
        CLUSTER_COLORS = new Color[]{Colors.create(242, 0, 0), Colors.create(255, 230, 0), Colors.create(0, 242, 0), Colors.create(61, 61, 244)};
    }

    public static final @NonNull Color adjust(Color color, float hueAdjustment, float saturationAdjustment, float brightnessAdjustment) {
        return Colors.create(RGBUtils.adjust(color.getRGB(), hueAdjustment, saturationAdjustment, brightnessAdjustment));
    }

    public static final @NonNull Color adjust(RGB rgb, float hueAdjustment, float saturationAdjustment, float brightnessAdjustment) {
        return Colors.create(RGBUtils.adjust(rgb, hueAdjustment, saturationAdjustment, brightnessAdjustment));
    }

    public static @NonNull Color blend(Color first, Color second, int percentage) {
        return Colors.create(RGBUtils.blend(first.getRGB(), second.getRGB(), percentage));
    }

    public static @NonNull Color blend(RGB first, RGB second, int percentage) {
        return Colors.create(RGBUtils.blend(first, second, percentage));
    }

    public static @NonNull Color create(int rgb) {
        return Colors.create(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
    }

    public static @NonNull Color create(int red, int green, int blue) {
        int rgbInt = RGBUtils.toInt(red, green, blue);
        Color color = (Color)MAP.get(rgbInt);
        if (color == null) {
            Display display = Display.getCurrent();
            if (display == null) {
                Colors.warnNonUIThread();
            }
            color = new Color((Device)display, new RGB(red, green, blue));
            MAP.put(rgbInt, (Object)color);
        }
        return color;
    }

    public static @NonNull Color create(RGB rgb) {
        return Colors.create(rgb.red, rgb.green, rgb.blue);
    }

    public static @NonNull Color @NonNull [] create(RGB ... rgb) {
        @NonNull Color @NonNull [] colors = new Color[rgb.length];
        int i = 0;
        while (i < rgb.length) {
            colors[i] = Colors.create(rgb[i]);
            ++i;
        }
        return colors;
    }

    public static @NonNull Color darken(Color color, int percentage) {
        return Colors.create(RGBUtils.darken(color.getRGB(), percentage));
    }

    public static @NonNull Color darken(RGB rgb, int percentage) {
        return Colors.create(RGBUtils.darken(rgb, percentage));
    }

    public static @NonNull Color getBlack() {
        return Colors.getSystemColor(2);
    }

    public static @NonNull Color getBlue() {
        return Colors.getSystemColor(9);
    }

    public static @NonNull Color getClusterColor(int cluster) {
        return CLUSTER_COLORS[(cluster >= 0 ? cluster : -cluster) % CLUSTER_COLORS.length];
    }

    public static @NonNull Color getCoreColor(int core) {
        return core >= 0 ? CORE_COLORS[core % CORE_COLORS.length] : Colors.getDarkGray();
    }

    public static @NonNull Color getCyan() {
        return Colors.getSystemColor(13);
    }

    public static @NonNull Color getDarkBlue() {
        return Colors.getSystemColor(10);
    }

    public static @NonNull Color getDarkCyan() {
        return Colors.getSystemColor(14);
    }

    public static @NonNull Color getDarkGray() {
        return Colors.getSystemColor(16);
    }

    public static @NonNull Color getDarkGreen() {
        return Colors.getSystemColor(6);
    }

    public static @NonNull Color getDarkMagenta() {
        return Colors.getSystemColor(12);
    }

    public static @NonNull Color getDarkRed() {
        return Colors.getSystemColor(4);
    }

    public static @NonNull Color getDarkYellow() {
        return Colors.getSystemColor(8);
    }

    public static @NonNull Color getDivider() {
        return Colors.getWidgetNormalShadow();
    }

    public static @NonNull Color getGray() {
        return Colors.getSystemColor(15);
    }

    public static @NonNull Color getGreen() {
        return Colors.getSystemColor(5);
    }

    public static @NonNull Color getInfoBackground() {
        return Colors.getSystemColor(29);
    }

    public static @NonNull Color getInfoForeground() {
        return Colors.getSystemColor(28);
    }

    public static @NonNull Color getInstructionHighlight() {
        return Colors.create(216, 255, 216);
    }

    public static @NonNull Color getLink() {
        return Colors.getSystemColor(36);
    }

    public static @NonNull Color getLinkPressed() {
        return Colors.darken(Colors.getLink(), 50);
    }

    public static @NonNull Color getListBackground() {
        return Colors.getSystemColor(25);
    }

    public static @NonNull Color getListForeground() {
        return Colors.getSystemColor(24);
    }

    public static @NonNull Color getListSelection() {
        return Colors.getSystemColor(26);
    }

    public static @NonNull Color getListSelectionText() {
        return Colors.getSystemColor(27);
    }

    public static @NonNull Color getMagenta() {
        return Colors.getSystemColor(11);
    }

    public static @NonNull Color getMarker() {
        return Colors.create(51, 51, 51);
    }

    public static @NonNull Color getOutlineDivider() {
        return Colors.isDarkModeUI() ? Colors.darken(Colors.getWidgetBackground(), 40) : Colors.create(224, 224, 224);
    }

    public static @NonNull Color getOutlineHierarchy() {
        return Colors.create(170, 170, 170);
    }

    public static @NonNull Color getPrimaryBanding() {
        return Colors.getListBackground();
    }

    public static @NonNull Color getRed() {
        return Colors.getSystemColor(3);
    }

    public static @NonNull Color getSecondaryBanding() {
        return Colors.isDarkModeUI() ? Colors.lighten(Colors.getWidgetBackground(), 5) : Colors.create(232, 248, 255);
    }

    public static @NonNull Color getSelection(boolean active) {
        Color color = Colors.getListSelection();
        if (!active) {
            color = Colors.lighten(color, 50);
        }
        return color;
    }

    public static @NonNull Color getSourceComments() {
        return Colors.create(63, 127, 95);
    }

    public static @NonNull Color getSourceKeywords() {
        return Colors.create(127, 0, 85);
    }

    public static @NonNull Color getSourceStrings() {
        return Colors.create(0, 0, 160);
    }

    public static @NonNull Color getText(boolean selectedAndActive) {
        return selectedAndActive ? Colors.getListSelectionText() : Colors.getListForeground();
    }

    public static @NonNull Color getTitleBackground() {
        return Colors.getSystemColor(31);
    }

    public static @NonNull Color getTitleBackgroundGradient() {
        return Colors.getSystemColor(32);
    }

    public static @NonNull Color getTitleForeground() {
        return Colors.getSystemColor(30);
    }

    public static @NonNull Color getTitleInactiveBackground() {
        return Colors.getSystemColor(34);
    }

    public static @NonNull Color getTitleInactiveBackgroundGradient() {
        return Colors.getSystemColor(35);
    }

    public static @NonNull Color getTitleInactiveForeground() {
        return Colors.getSystemColor(33);
    }

    public static @NonNull Color getWhite() {
        return Colors.getSystemColor(1);
    }

    public static @NonNull Color getWidgetBackground() {
        return Colors.getSystemColor(22);
    }

    public static @NonNull Color getWidgetBorder() {
        return Colors.getSystemColor(23);
    }

    public static @NonNull Color getWidgetDarkShadow() {
        return Colors.getSystemColor(17);
    }

    public static @NonNull Color getWidgetForeground() {
        return Colors.getSystemColor(21);
    }

    public static @NonNull Color getWidgetHighlightShadow() {
        return Colors.getSystemColor(20);
    }

    public static @NonNull Color getWidgetLightShadow() {
        return Colors.getSystemColor(19);
    }

    public static @NonNull Color getWidgetNormalShadow() {
        return Colors.getSystemColor(18);
    }

    public static @NonNull Color getYellow() {
        return Colors.getSystemColor(7);
    }

    public static final Color grayscale(Color color) {
        return Colors.create(RGBUtils.grayscale(color.getRGB()));
    }

    public static final Color grayscale(RGB rgb) {
        return Colors.create(RGBUtils.grayscale(rgb));
    }

    public static @NonNull Color heat(double percentage) {
        return Colors.create(RGBUtils.heat(percentage));
    }

    public static boolean isDark(Color color) {
        return RGBUtils.isDark(color.getRGB());
    }

    public static boolean isLight(Color color) {
        return RGBUtils.isLight(color.getRGB());
    }

    public static int compareBrightness(Color a, Color b) {
        return RGBUtils.perceivedBrightness(a.getRGB()) - RGBUtils.perceivedBrightness(b.getRGB());
    }

    public static boolean isDarkModeUI() {
        return Colors.compareBrightness(Colors.getWidgetBackground(), Colors.getWidgetForeground()) < 0;
    }

    public static boolean isMonochrome(Color color) {
        return color.getRed() == color.getGreen() && color.getGreen() == color.getBlue();
    }

    public static @NonNull Color lighten(Color color, int percentage) {
        return Colors.create(RGBUtils.lighten(color.getRGB(), percentage));
    }

    public static @NonNull Color lighten(RGB rgb, int percentage) {
        return Colors.create(RGBUtils.lighten(rgb, percentage));
    }

    public static int perceivedBrightness(Color color) {
        return RGBUtils.perceivedBrightness(color.getRGB());
    }

    private static synchronized @NonNull Color getSystemColor(int swtSystemColorConstant) {
        Color color = (Color)MAP.get(Integer.MIN_VALUE | swtSystemColorConstant);
        if (color == null) {
            Display display = Display.getCurrent();
            if (display == null) {
                Colors.warnNonUIThread();
                display = Display.getDefault();
            }
            if ((color = display.getSystemColor(swtSystemColorConstant)) == null) {
                StreamlinePlugin.warning("Invalid system color constant: " + swtSystemColorConstant);
                color = display.getSystemColor(3);
            }
            MAP.put(Integer.MIN_VALUE | swtSystemColorConstant, (Object)color);
            int key = RGBUtils.toInt(color.getRGB());
            if (!MAP.contains(key)) {
                MAP.put(key, (Object)color);
            }
        }
        return color;
    }

    private static final void warnNonUIThread() {
        StreamlinePlugin.warning("Colors should only be created on the UI thread. Use RGB objects instead if you need to create color information on a non-UI thread.");
    }

    private Colors() {
    }
}

