/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility.text;

import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.utility.text.StringTruncator;
import com.arm.streamline.utility.text.TextDrawingState;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.Fonts;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class TextDrawing {
    public static final char ELLIPSIS_CHAR = '\u2026';
    public static final String ELLIPSIS = "\u2026";
    public static final String LINE_ENDING = "\n";
    private static final int LARGISH_STRING_LENGTH = 128;
    private static final int H_MARGIN = 4;
    private static final int V_MARGIN = 2;

    public static @NonNull Image createTextImage(@NonNull String text, @Nullable Display display) {
        FontInfo fontInfo = FontInfo.get(Fonts.getNormal());
        int width = fontInfo.getWidth(text) + 8;
        int height = fontInfo.getHeight() + 4;
        Image image = new Image((Device)display, width, height);
        GC gc = new GC((Drawable)image);
        gc.setBackground(Colors.getWhite());
        gc.fillRectangle(0, 0, width, height);
        gc.setForeground(Colors.getDarkGray());
        gc.drawRectangle(0, 0, width - 1, height - 1);
        gc.setForeground(Colors.getBlack());
        TextDrawing.drawString(gc, text, 4, 2, 16384);
        gc.dispose();
        return image;
    }

    public static void drawString(GC gc, String text, int x, int y) {
        TextDrawing.drawString(gc, text, x, y, 16384);
    }

    public static void drawString(GC gc, String text, int x, int y, int alignment) {
        TextDrawing.drawString(gc, text, x, y, alignment, true);
    }

    public static void drawString(GC gc, String text, int x, int y, int alignment, boolean transparent) {
        TextDrawingState state = new TextDrawingState(gc);
        int start = x;
        if (alignment == 0x1000000) {
            start -= gc.stringExtent((String)text).x / 2;
        } else if (alignment == 131072) {
            start -= gc.stringExtent((String)text).x;
        }
        gc.drawString(text, start, y, transparent);
        state.restore();
    }

    public static int drawString(GC gc, String text, int x, int y, int width, int hAlign) {
        return TextDrawing.drawString(gc, text, x, y, width, hAlign, 131072);
    }

    public static int drawString(GC gc, String text, int x, int y, int width, int hAlign, int truncation) {
        return TextDrawing.drawString(gc, text, x, y, width, hAlign, truncation, true);
    }

    public static int drawString(GC gc, String text, int x, int y, int width, int hAlign, int truncation, boolean transparent) {
        return TextDrawing.drawString(gc, text, x, y, width, 0, hAlign, 128, truncation, transparent);
    }

    public static int drawString(GC gc, String text, int x, int y, int width, int height, int hAlign, int vAlign) {
        return TextDrawing.drawString(gc, text, x, y, width, height, hAlign, vAlign, 131072, true);
    }

    public static int drawString(GC gc, String text, int x, int y, int width, int height, int hAlign, int vAlign, int truncation) {
        return TextDrawing.drawString(gc, text, x, y, width, height, hAlign, vAlign, truncation, true);
    }

    public static int drawString(GC gc, String text, int x, int y, int width, int height, int hAlign, int vAlign, int truncation, boolean transparent) {
        TextDrawingState state = new TextDrawingState(gc);
        text = TextDrawing.truncateStringWithoutGCSetup(gc, text, width, truncation);
        Point extent = gc.stringExtent(text);
        if (hAlign == 0x1000000) {
            x += (width - extent.x) / 2;
        } else if (hAlign == 131072) {
            extent = gc.stringExtent(text);
            x += width - extent.x;
        }
        if (vAlign == 0x1000000) {
            y += (height - extent.y) / 2;
        } else if (vAlign == 1024) {
            y += height - extent.y;
        }
        gc.drawString(text, x, y, transparent);
        state.restore();
        return x + extent.x;
    }

    public static void drawText(GC gc, String text, int x, int y, int alignment) {
        TextDrawing.drawText(gc, text, x, y, alignment, true);
    }

    public static void drawText(GC gc, String text, int x, int y, int alignment, boolean transparent) {
        TextDrawingState state = new TextDrawingState(gc);
        int fontHeight = FontInfo.get(gc.getFont()).getHeight();
        boolean lastWasReturn = true;
        StringTokenizer tokenizer = new StringTokenizer(text, LINE_ENDING, true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (LINE_ENDING.equals(token)) {
                if (lastWasReturn) {
                    y += fontHeight;
                    continue;
                }
                lastWasReturn = true;
                continue;
            }
            lastWasReturn = false;
            int start = x;
            if (alignment == 0x1000000) {
                start -= gc.stringExtent((String)token).x / 2;
            } else if (alignment == 131072) {
                start -= gc.stringExtent((String)token).x;
            }
            gc.drawString(token, start, y, transparent);
            y += fontHeight;
        }
        state.restore();
    }

    public static void drawText(GC gc, String text, int x, int y, int width, int height, int hAlign, int vAlign) {
        TextDrawing.drawText(gc, text, x, y, width, height, hAlign, vAlign, 131072, true);
    }

    public static void drawText(GC gc, String text, int x, int y, int width, int height, int hAlign, int vAlign, int truncation, boolean transparent) {
        int fontHeight = FontInfo.get(gc.getFont()).getHeight();
        int totalHeight = 0;
        boolean lastWasReturn = true;
        ArrayList<String> lines = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(text, LINE_ENDING, true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (LINE_ENDING.equals(token)) {
                if (lastWasReturn) {
                    lines.add("");
                    totalHeight += fontHeight;
                    continue;
                }
                lastWasReturn = true;
                continue;
            }
            lastWasReturn = false;
            lines.add(token);
            totalHeight += fontHeight;
        }
        if (vAlign == 0x1000000) {
            y += (height - totalHeight) / 2;
        } else if (vAlign == 1024) {
            y += height - totalHeight;
        }
        for (String line : lines) {
            TextDrawing.drawString(gc, line, x, y, width, fontHeight, hAlign, 128, truncation, transparent);
            y += fontHeight;
        }
    }

    public static void drawWrappedText(GC gc, String text, int x, int y, int width, int height, int hAlign, int vAlign) {
        int fontHeight = FontInfo.get(gc.getFont()).getHeight();
        int totalHeight = 0;
        ArrayList<Object> lines = new ArrayList<Object>();
        StringTokenizer tokenizer = new StringTokenizer(text, "\n\t ", true);
        Object current = "";
        while (tokenizer.hasMoreTokens()) {
            String string = tokenizer.nextToken();
            if (LINE_ENDING.equals(string)) {
                lines.add(current);
                current = "";
                totalHeight += fontHeight;
                continue;
            }
            String proposed = (String)current + string;
            if (gc.stringExtent((String)proposed).x > width) {
                if (!((String)current).isEmpty()) {
                    lines.add(current);
                    totalHeight += fontHeight;
                }
                if (string.equals(" ")) {
                    current = "";
                    continue;
                }
                current = string;
                continue;
            }
            current = proposed;
        }
        if (!((String)current).isEmpty()) {
            lines.add(current);
            totalHeight += fontHeight;
        }
        if (vAlign == 0x1000000) {
            y += (height - totalHeight) / 2;
        } else if (vAlign == 1024) {
            y += height - totalHeight;
        }
        for (String string : lines) {
            TextDrawing.drawString(gc, string, x, y, width, fontHeight, hAlign, 128, 131072, true);
            y += fontHeight;
        }
    }

    public static final @NonNull String expandTabs(@NonNull String text, int startingPosition, int tabWidth) {
        return TextDrawing.expandTabs(text, startingPosition, tabWidth, null);
    }

    public static final @NonNull String expandTabs(@NonNull String text, int startingPosition, int tabWidth, int[] indexes) {
        int length = text.length();
        int column = startingPosition;
        StringBuilder buffer = new StringBuilder(length * 2);
        int i = 0;
        while (i < length) {
            char ch = text.charAt(i);
            if (indexes != null) {
                indexes[i] = column - startingPosition;
            }
            if (ch == '\t') {
                int spaces = tabWidth - column % tabWidth;
                while (--spaces >= 0) {
                    buffer.append(' ');
                    ++column;
                }
            } else {
                buffer.append(ch);
                column = ch != '\n' ? ++column : 0;
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String makeFiller(int amt, char filler) {
        StringBuilder buffer = new StringBuilder(amt);
        int i = 0;
        while (i < amt) {
            buffer.append(filler);
            ++i;
        }
        return buffer.toString();
    }

    public static final String truncateString(Font font, String str, int width, int where) {
        return TextDrawing.truncateString(FontInfo.get(font).getMeasurementGC(), str, width, where);
    }

    public static final String truncateString(GC gc, String str, int width, int where) {
        TextDrawingState state = new TextDrawingState(gc);
        str = TextDrawing.truncateStringWithoutGCSetup(gc, str, width, where);
        state.restore();
        return str;
    }

    public static final String truncateStringWithoutGCSetup(GC gc, String str, int width, int where) {
        String result;
        if (width < 1 || str.isEmpty()) {
            return "";
        }
        int current = gc.stringExtent((String)str).x;
        if (current <= width) {
            return str;
        }
        StringBuilder buffer = new StringBuilder();
        switch (where) {
            case 131072: {
                if (str.length() > 128) {
                    StringTruncator truncator = new StringTruncator(str, current, param -> gC.stringExtent((String)param).x);
                    String truncated = truncator.truncateFromRight(width, ELLIPSIS);
                    return truncated;
                }
                int length = str.length() + 1;
                current += gc.getAdvanceWidth('\u2026');
                buffer.append(str);
                buffer.append('\u2026');
                while (current > width && --length > 0) {
                    buffer.deleteCharAt(length - 1);
                    if ((current -= gc.getAdvanceWidth(buffer.charAt(length - 1))) <= width) break;
                }
                while (gc.stringExtent((String)buffer.toString()).x > width && --length > 0) {
                    buffer.deleteCharAt(length - 1);
                }
                break;
            }
            case 0x1000000: {
                StringBuilder left = new StringBuilder();
                StringBuilder right = new StringBuilder();
                int middle = str.length() / 2;
                if (middle > 0) {
                    left.append(str.substring(0, middle));
                }
                if (middle < str.length()) {
                    right.append(str.substring(middle));
                }
                int leftLength = left.length();
                int rightLength = right.length();
                boolean leftSide = true;
                current += gc.getAdvanceWidth('\u2026');
                while (leftLength > 0 && rightLength > 0) {
                    if (leftSide) {
                        if (leftLength > 0) {
                            current -= gc.getAdvanceWidth(left.charAt(--leftLength));
                            left.deleteCharAt(leftLength);
                        }
                    } else if (rightLength > 0) {
                        current -= gc.getAdvanceWidth(right.charAt(0));
                        --rightLength;
                        right.deleteCharAt(0);
                    }
                    boolean bl = leftSide = !leftSide;
                    if (current <= width) break;
                }
                buffer.setLength(0);
                buffer.append((CharSequence)left);
                buffer.append('\u2026');
                buffer.append((CharSequence)right);
                while (gc.stringExtent((String)buffer.toString()).x > width && leftLength > 0 && rightLength > 0) {
                    if (leftSide) {
                        if (leftLength > 0) {
                            left.deleteCharAt(--leftLength);
                        }
                    } else if (rightLength > 0) {
                        --rightLength;
                        right.deleteCharAt(0);
                    }
                    leftSide = !leftSide;
                    buffer.setLength(0);
                    buffer.append((CharSequence)left);
                    buffer.append('\u2026');
                    buffer.append((CharSequence)right);
                }
                break;
            }
            default: {
                current += gc.getAdvanceWidth('\u2026');
                buffer.append('\u2026');
                buffer.append(str);
                int length = buffer.length();
                while (current > width && --length > 0) {
                    buffer.deleteCharAt(1);
                    if ((current -= gc.getAdvanceWidth(buffer.charAt(1))) <= width) break;
                }
                while (gc.stringExtent((String)buffer.toString()).x > width && --length > 0) {
                    buffer.deleteCharAt(1);
                }
                break block0;
            }
        }
        if (ELLIPSIS.equals(result = buffer.toString()) && gc.stringExtent((String)result).x > width) {
            result = "..";
            if (gc.stringExtent((String)result).x > width) {
                result = ".";
                if (gc.stringExtent((String)result).x > width) {
                    result = "";
                }
            }
        }
        return result;
    }

    public static final String truncateText(Font font, String text, int width, int where) {
        return TextDrawing.truncateText(FontInfo.get(font).getMeasurementGC(), text, width, where);
    }

    public static final String truncateText(GC gc, String text, int width, int where) {
        StringTokenizer tokenizer = new StringTokenizer(text, LINE_ENDING, true);
        StringBuilder buffer = new StringBuilder();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (LINE_ENDING.equals(token)) {
                buffer.append(token);
                continue;
            }
            buffer.append(TextDrawing.truncateString(gc, token, width, where));
        }
        return buffer.toString();
    }
}

