/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility.text;

import com.arm.streamline.common.utility.text.NumberUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ScaledFormat {
    private static final int MAX_FRACTIONAL_DIGITS = 13;
    private final boolean mAsInteger;
    private final @NonNull BaseFormat mBaseFormat;
    private final int mFractionalDigits;

    public static @NonNull String format(double value, boolean percentage, int significantDigits, String units) {
        return ScaledFormat.getBestFormat(value, percentage, significantDigits, units).format(value, units);
    }

    public static @NonNull String formatForReport(double value, boolean percentage, int significantDigits, String units) {
        if (percentage) {
            ScaledFormat formatForReport = new ScaledFormat(BaseFormat.PERCENT_NO_POSTFIX, significantDigits < 0 ? 2 : significantDigits, false);
            return formatForReport.format(value, units, false);
        }
        return ScaledFormat.getBestFormat(value, percentage, significantDigits, units).format(value, units, false);
    }

    public static @NonNull ScaledFormat getBestFormat(double value, boolean percentage, int significantDigits, String units) {
        boolean asInteger;
        if (percentage) {
            return new ScaledFormat(BaseFormat.PERCENT, significantDigits < 0 ? 2 : significantDigits, false);
        }
        value = Math.abs(value);
        @NonNull BaseFormat baseFormat = ScaledFormat.shouldUseKibi(units) ? (value < 1024.0 ? BaseFormat.NONE : (value < 1048576.0 ? BaseFormat.KIBIBYTE : (value < 1.073741824E9 ? BaseFormat.MEBIBYTE : BaseFormat.GIBIBYTE))) : (units != null && !units.isEmpty() ? (value == 0.0 ? BaseFormat.ZERO : (value < 1.0E-6 ? BaseFormat.NANO : (value < 0.001 ? BaseFormat.MICRO : (value < 1.0 ? BaseFormat.MILLI : (value < 1000.0 ? BaseFormat.NONE : (value < 1000000.0 ? BaseFormat.KILO : (value < 1.0E9 ? BaseFormat.MEGA : BaseFormat.GIGA))))))) : BaseFormat.NONE);
        boolean bl = asInteger = value == 0.0 || significantDigits < 0 && (units == null || units.isEmpty()) && value == (double)((long)value);
        if (asInteger) {
            if (value == 0.0) {
                return new ScaledFormat(BaseFormat.ZERO, 0, true);
            }
            return new ScaledFormat(baseFormat, 0, true);
        }
        if (significantDigits < 0) {
            significantDigits = 2;
        }
        int exponent = NumberUtils.getExponent10((double)(value / baseFormat.divisor));
        int fractionalDigits = Math.min(Math.max(0, significantDigits - exponent), 13);
        return new ScaledFormat(baseFormat, fractionalDigits, false);
    }

    public static boolean shouldUseKibi(@Nullable String units) {
        return units != null && (units.equalsIgnoreCase("B") || units.equalsIgnoreCase("byte") || units.equalsIgnoreCase("bytes"));
    }

    public ScaledFormat(@NonNull BaseFormat baseFormat, int fractionalDigits, boolean asInteger) {
        this.mBaseFormat = baseFormat;
        this.mFractionalDigits = Math.min(fractionalDigits, 13);
        this.mAsInteger = asInteger;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ScaledFormat)) {
            return false;
        }
        ScaledFormat other = (ScaledFormat)obj;
        if (this.mAsInteger != other.mAsInteger) {
            return false;
        }
        if (this.mFractionalDigits != other.mFractionalDigits) {
            return false;
        }
        return this.mBaseFormat == other.mBaseFormat;
    }

    public @NonNull String format(double value, @Nullable String units) {
        return this.format(value, units, true);
    }

    public @NonNull String format(double value, @Nullable String units, boolean localised) {
        StringBuilder buffer = new StringBuilder();
        if ((value /= this.mBaseFormat.divisor) < 0.0 || Double.isNaN(value)) {
            buffer.append('-');
        } else {
            String mPostfix;
            if (this.mAsInteger && localised) {
                buffer.append(NumberUtils.prettyFormat((long)((long)value)));
            } else if (this.mAsInteger && !localised) {
                buffer.append(NumberUtils.prettyFormatUngrouped((long)((long)value)));
            } else if (localised) {
                buffer.append(NumberUtils.prettyFormat((double)value, (int)this.mFractionalDigits, (boolean)true));
            } else {
                buffer.append(NumberUtils.prettyFormatUngrouped((double)value, (int)this.mFractionalDigits, (boolean)true));
            }
            boolean useLongPostfix = units != null && units.length() > 2;
            String string = mPostfix = useLongPostfix ? this.mBaseFormat.longPostfix : this.mBaseFormat.shortPostfix;
            if (mPostfix != null && mPostfix.equals("%")) {
                buffer.append('%');
            } else if (mPostfix != null || units != null && !units.isEmpty()) {
                buffer.append(' ');
                if (mPostfix != null) {
                    buffer.append(mPostfix);
                    if (useLongPostfix && units != null) {
                        buffer.append('-');
                    }
                }
                if (units != null) {
                    buffer.append(units);
                }
            }
        }
        return buffer.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mAsInteger ? 1231 : 1237);
        result = 31 * result + this.mFractionalDigits;
        result = 31 * result + this.mBaseFormat.hashCode();
        return result;
    }

    public @NonNull ScaledFormat mergeWith(@NonNull ScaledFormat other) {
        boolean asInteger = this.mAsInteger && other.mAsInteger;
        ScaledFormat chosen = this.mBaseFormat.divisor < other.mBaseFormat.divisor || this.mBaseFormat.divisor == other.mBaseFormat.divisor && this.mFractionalDigits > other.mFractionalDigits ? other : this;
        return new ScaledFormat(chosen.mBaseFormat, chosen.mFractionalDigits, asInteger);
    }

    public String toString() {
        return String.format("ScaledFormat [mAsInteger=%s, mFractionalDigits=%s, mBaseFormat=%s]", new Object[]{this.mAsInteger, this.mFractionalDigits, this.mBaseFormat});
    }

    public static enum BaseFormat {
        GIBIBYTE("Gi", "gibi", 1.073741824E9),
        GIGA("G", "giga", 1.0E9),
        KIBIBYTE("Ki", "kibi", 1024.0),
        KILO("k", "kilo", 1000.0),
        MEBIBYTE("Mi", "mebi", 1048576.0),
        MEGA("M", "mega", 1000000.0),
        MICRO("\u00b5", "micro", 1.0E-6),
        MILLI("m", "milli", 0.001),
        NANO("n", "nano", 1.0E-9),
        NONE(1.0),
        PERCENT("%", "%", 0.01),
        PERCENT_NO_POSTFIX("", "", 0.01),
        ZERO(Double.MIN_NORMAL);

        public final double divisor;
        public final @Nullable String longPostfix;
        public final @Nullable String shortPostfix;

        private BaseFormat(double divisor) {
            this(null, null, divisor);
        }

        private BaseFormat(String shortPostfix, String longPostfix, double divisor) {
            this.shortPostfix = shortPostfix;
            this.longPostfix = longPostfix;
            this.divisor = divisor;
        }
    }
}

