/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility.target;

import com.arm.streamline.authentication.TargetAuthentication;
import com.arm.streamline.utility.target.AuthFailedException;
import com.arm.streamline.utility.target.CredentialsAddress;
import com.arm.streamline.utility.target.ICredentials;
import com.arm.streamline.utility.target.IRemoteTransfer;
import com.arm.streamline.utility.target.MyUserInfo;
import com.arm.streamline.utility.target.NullProgressMonitor;
import com.arm.streamline.widget.Error;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class LinuxRemoteTransfer
implements IRemoteTransfer {
    private ICredentials mCredentials;
    private Session mSession;
    private ChannelSftp mSftp;
    private final @NonNull IProgressMonitor monitor;

    public LinuxRemoteTransfer(ICredentials credentials, @NonNull IProgressMonitor monitor) {
        this.mCredentials = credentials;
        this.monitor = monitor;
    }

    @Override
    public void close() throws IOException {
        if (this.mSession != null) {
            this.mSession.disconnect();
            this.mSession = null;
            this.mSftp = null;
        }
    }

    @Override
    public @Nullable File copy(@NonNull String src, @NonNull File dst) throws IOException, InterruptedException {
        boolean isSuccess = false;
        try {
            if (this.mSftp == null) {
                Session session = null;
                ChannelSftp sftp = null;
                while (!this.monitor.isCanceled()) {
                    try {
                        JSch jsch = IRemoteTransfer.createJSch();
                        CredentialsAddress address = this.mCredentials.getAddress();
                        assert (!address.android);
                        String hostname = address.address;
                        session = jsch.getSession(this.mCredentials.getUsername(), hostname, 22);
                        session.setUserInfo((UserInfo)new MyUserInfo(this.mCredentials));
                        session.connect(5000);
                        sftp = (ChannelSftp)session.openChannel("sftp");
                        sftp.connect(5000);
                        isSuccess = true;
                    }
                    catch (AuthFailedException e) {
                        if (session != null) {
                            session.disconnect();
                            session = null;
                        }
                        Error.show(e);
                        this.mCredentials = this.mCredentials.reprompt();
                        if (this.mCredentials != null) continue;
                        isSuccess = false;
                    }
                    break;
                }
                if (this.monitor.isCanceled()) {
                    this.mCredentials = null;
                    isSuccess = false;
                } else if (isSuccess) {
                    this.mSession = session;
                    this.mSftp = sftp;
                }
            } else {
                isSuccess = true;
            }
            if (isSuccess) {
                TargetAuthentication.cache(LinuxRemoteTransfer.asTargetAuth(this.mCredentials));
                SftpATTRS s = this.mSftp.stat(src);
                this.mSftp.get(src, dst.getAbsolutePath(), (SftpProgressMonitor)new NullProgressMonitor(), 0);
                if (dst.isDirectory()) {
                    File srcFile = new File(src);
                    dst = new File(dst, srcFile.getName());
                }
                dst.setLastModified((long)s.getMTime() * 1000L);
            }
        }
        catch (JSchException e) {
            if (!isSuccess) {
                this.mCredentials = null;
            }
        }
        catch (SftpException e) {
            throw new IOException(e);
        }
        return isSuccess ? dst : null;
    }

    private static @NonNull TargetAuthentication asTargetAuth(@NonNull ICredentials credentials) {
        TargetAuthentication auth = new TargetAuthentication();
        auth.setAddress(credentials.getAddress());
        auth.setUserName(credentials.getUsername());
        auth.setPassword(credentials.getPassword());
        return auth;
    }

    @Override
    public boolean shouldCacheTargetAuthentication() {
        return this.mCredentials != null;
    }
}

