/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility.target;

import com.arm.streamline.utility.AdbRunnerFactory;
import com.arm.streamline.utility.target.AndroidRemoteTransfer;
import com.arm.streamline.utility.target.CredentialsAddress;
import com.arm.streamline.utility.target.ICredentials;
import com.arm.streamline.utility.target.LinuxRemoteTransfer;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public interface IRemoteTransfer
extends Closeable {
    public static @NonNull IRemoteTransfer construct(ICredentials credentials, @Nullable File pathToAdb, @NonNull IProgressMonitor monitor) throws IOException {
        CredentialsAddress address = credentials.getAddress();
        if (address.android) {
            if (pathToAdb == null) {
                throw new FileNotFoundException("adb executable");
            }
            return new AndroidRemoteTransfer(AdbRunnerFactory.SINGLETON.create(AdbRunnerFactory.SINGLETON.create(pathToAdb), address.address), monitor);
        }
        return new LinuxRemoteTransfer(credentials, monitor);
    }

    public static JSch createJSch() {
        JSch jsch = new JSch();
        String basePath = System.getProperty("user.home") + "/.ssh/";
        IRemoteTransfer.addIdentity(jsch, basePath + "id_dsa");
        IRemoteTransfer.addIdentity(jsch, basePath + "id_ecdsa");
        IRemoteTransfer.addIdentity(jsch, basePath + "id_rsa");
        return jsch;
    }

    public static void addIdentity(JSch jsch, String path) {
        try {
            jsch.addIdentity(path);
        }
        catch (JSchException jSchException) {
            // empty catch block
        }
    }

    public @Nullable File copy(@NonNull String var1, @NonNull File var2) throws IOException, InterruptedException;

    public boolean shouldCacheTargetAuthentication();
}

