/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility.io;

import java.util.HashMap;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public class LocalObjectTransfer<T>
extends ByteArrayTransfer {
    private static final HashMap<Class<?>, LocalObjectTransfer<?>> MAP = new HashMap();
    private Class<T> mDataType;
    private String mTypeName;
    private int mTypeID;
    private T[] mData;

    public static final <T> LocalObjectTransfer<T> get(Class<? extends T> dataType) {
        LocalObjectTransfer<Object> transfer = MAP.get(dataType);
        if (transfer == null) {
            transfer = new LocalObjectTransfer<T>(dataType);
            MAP.put(dataType, transfer);
        }
        return transfer;
    }

    private LocalObjectTransfer(Class<T> dataType) {
        this.mDataType = dataType;
        this.mTypeName = ((Object)((Object)this)).getClass().getName() + ":" + this.mDataType.getName() + ":" + System.currentTimeMillis();
        this.mTypeID = LocalObjectTransfer.registerType((String)this.mTypeName);
    }

    public T[] getTransferObjects() {
        return this.mData;
    }

    public void javaToNative(Object object, TransferData transferData) {
        super.javaToNative((Object)this.mTypeName.getBytes(), transferData);
    }

    public Object nativeToJava(TransferData transferData) {
        Object result = super.nativeToJava(transferData);
        if (result instanceof byte[] && this.mTypeName.equals(new String((byte[])result))) {
            return this.mData;
        }
        return null;
    }

    public void setTransferObjects(T[] transferObjects) {
        this.mData = transferObjects;
    }

    protected int[] getTypeIds() {
        return new int[]{this.mTypeID};
    }

    protected String[] getTypeNames() {
        return new String[]{this.mTypeName};
    }

    protected boolean validate(Object object) {
        return object != null && this.mDataType.isAssignableFrom(object.getClass());
    }
}

