/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility.expression2;

import com.arm.streamline.utility.expression2.ExpressionException;
import com.arm.streamline.utility.expression2.ExpressionNodeFactory;
import com.arm.streamline.utility.expression2.Parser;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class ExpressionData {
    private final @NonNull String expression;
    private boolean parsed;
    private @Nullable ExpressionException parserException;
    private @Nullable ExpressionNodeFactory.IBaseExpressionNode syntaxTree;

    public ExpressionData(@NonNull String expression) {
        this.expression = expression;
    }

    public @Nullable String asSingleSourceNameExpression() {
        ExpressionNodeFactory.IBaseExpressionNode tree = this.getSyntaxTreeOrNull();
        if (tree != null) {
            return tree.asSingleSourceNameExpression();
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExpressionData other = (ExpressionData)obj;
        return Objects.equals(this.expression, other.expression);
    }

    public @NonNull String getString() {
        return this.expression;
    }

    public @Nullable ExpressionNodeFactory.IBaseExpressionNode getSyntaxTree() throws ExpressionException {
        boolean parsed = this.parsed;
        if (!parsed) {
            return this.parse();
        }
        ExpressionException parserException = this.parserException;
        if (parserException != null) {
            throw parserException;
        }
        return this.syntaxTree;
    }

    public @Nullable ExpressionNodeFactory.IBaseExpressionNode getSyntaxTreeOrNull() {
        try {
            return this.getSyntaxTree();
        }
        catch (ExpressionException e) {
            return null;
        }
    }

    public int hashCode() {
        return Objects.hash(this.expression);
    }

    public String toString() {
        return this.expression;
    }

    private synchronized @Nullable ExpressionNodeFactory.IBaseExpressionNode parse() throws ExpressionException {
        try {
            ExpressionNodeFactory.IBaseExpressionNode syntaxTree;
            this.syntaxTree = syntaxTree = Parser.parse(new ExpressionNodeFactory(), this.expression);
            ExpressionNodeFactory.IBaseExpressionNode iBaseExpressionNode = syntaxTree;
            return iBaseExpressionNode;
        }
        catch (ExpressionException e) {
            this.parserException = e;
            throw e;
        }
        finally {
            this.parsed = true;
        }
    }
}

