/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility;

import com.arm.streamline.analysis.database.stream.factory.AnalysisDatabaseFactory;
import com.arm.streamline.common.analysis.IAnalysisHandler;
import com.arm.streamline.jni.common.IProgressMonitor;
import com.arm.streamline.jni.common.WarningItem;
import com.arm.streamline.jni.common.WarningSeverity;
import com.arm.streamline.jni.common.WarningType;
import com.arm.utils.NullChecking;
import java.io.File;
import org.eclipse.jdt.annotation.NonNull;

public final class HandlerProgressMonitor
implements IProgressMonitor {
    private final @NonNull Thread currentThread;
    private final @NonNull IAnalysisHandler handler;
    private final long startTimestamp = System.nanoTime();
    private final @NonNull String capturePath;
    private int currentPercent = 0;
    private @NonNull String currentLabel = "";
    private long lastTimestamp = this.startTimestamp;
    private final @NonNull String name;

    private static @NonNull WarningType guessWarningType(@NonNull String name) {
        String nameLower = name.toLowerCase();
        if (nameLower.contains("elf") && nameLower.contains("dwarf")) {
            return WarningType.ELF_DWARF;
        }
        if (nameLower.contains("database")) {
            return WarningType.DATABASE;
        }
        return WarningType.SESSION_PROCESSOR;
    }

    public HandlerProgressMonitor(@NonNull IAnalysisHandler handler, @NonNull File apcDirectory, @NonNull String name) {
        this.handler = handler;
        this.currentThread = (Thread)NullChecking.neverNull((Object)Thread.currentThread());
        this.capturePath = apcDirectory.getAbsolutePath();
        this.name = name;
    }

    public void done() {
        this.updateAndLog(100, false);
    }

    public void updateLabel(@NonNull String label) {
        if (!NullChecking.equalsNullable((Object)this.currentLabel, (Object)label)) {
            this.currentLabel = label;
            this.updateAndLog(this.currentPercent, true);
        }
    }

    public void updatePercent(int percent) {
        this.updateAndLog(percent, false);
        if (this.currentThread.isInterrupted()) {
            throw new AsyncInterruptedException();
        }
    }

    public void warning(@NonNull String message) {
        this.handler.warning(new WarningItem(HandlerProgressMonitor.guessWarningType(this.name), WarningSeverity.MEDIUM, this.name, message));
    }

    private void updateAndLog(int percent, boolean changed) {
        if (this.currentPercent < percent && percent <= 100 && percent >= 0) {
            this.currentPercent = percent;
            changed = true;
            this.handler.progress((Object)this, this.currentPercent);
        }
        long now = System.nanoTime();
        long deltaPrint = now - this.lastTimestamp;
        if (AnalysisDatabaseFactory.ENABLE_V3_LOGGING && (changed || deltaPrint > 1000000000L)) {
            long deltaStart = now - this.startTimestamp;
            this.lastTimestamp = now;
            System.out.printf("%s: %d%%%s: TOTAL TIME: %d.%09d%n", this.capturePath, this.currentPercent, this.currentLabel.isBlank() ? "" : String.format(" [%s]", this.currentLabel), deltaStart / 1000000000L, deltaStart % 1000000000L);
        }
    }

    public static final class AsyncInterruptedException
    extends RuntimeException {
    }
}

