/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.ui.part.lpv;

import com.arm.streamline.databrowser.TargetAddressString;
import com.arm.streamline.ui.vm.ITcpTargetLauncher;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class TcpTargetLauncher
implements ITcpTargetLauncher {
    private final @NonNull TargetAddressString address;
    private final @NonNull String commandPath;
    private final boolean commandStopOnExit;
    private final @NonNull String commandUserName;
    private final @NonNull String commandWorkingDir;

    public static @Nullable TcpTargetLauncher create(@NonNull String addressStr, @NonNull String commandPath, @NonNull String commandWorkingDir, @NonNull String commandUserName, boolean commandStopOnExit) {
        TargetAddressString address = new TargetAddressString(addressStr);
        if (!address.isValid()) {
            return null;
        }
        return new TcpTargetLauncher(address, commandPath, commandWorkingDir, commandUserName, commandStopOnExit);
    }

    private TcpTargetLauncher(@NonNull TargetAddressString address, @NonNull String commandPath, @NonNull String commandWorkingDir, @NonNull String commandUserName, boolean commandStopOnExit) {
        this.address = address;
        this.commandPath = commandPath;
        this.commandWorkingDir = commandWorkingDir;
        this.commandUserName = commandUserName;
        this.commandStopOnExit = commandStopOnExit;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TcpTargetLauncher) {
            TcpTargetLauncher that = (TcpTargetLauncher)obj;
            return this.address.equals(that.address);
        }
        return false;
    }

    public String getCommandPath() {
        return this.commandPath;
    }

    public @NonNull String getCommandUsername() {
        return this.commandUserName;
    }

    public String getCommandWorkingDir() {
        return this.commandWorkingDir;
    }

    public @NonNull String getTargetAddress() {
        return this.address.toString();
    }

    public int hashCode() {
        return this.address.hashCode();
    }

    public boolean isCommandStopOnExit() {
        return this.commandStopOnExit;
    }

    public String toString() {
        return this.address.toString();
    }
}

