/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.ui.part.lpv;

import com.arm.streamline.databrowser.TargetAddressString;
import com.arm.streamline.deviceconn.adb.AdbDeviceRootMode;
import com.arm.streamline.ui.vm.IAndroidTargetDevice;
import com.arm.streamline.ui.vm.RunAsInfo;
import java.util.Optional;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import org.eclipse.jdt.annotation.NonNull;

public class AndroidTargetDevice
implements IAndroidTargetDevice {
    static final int PRIME_NUMBER = 31;
    private final @NonNull SimpleObjectProperty<// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IAndroidTargetDevice.Status> status = new SimpleObjectProperty();
    private final @NonNull SimpleStringProperty tooltipProperty;
    private final @NonNull TargetAddressString targetAddress;
    private @NonNull AdbDeviceRootMode deviceRootMode;
    private @NonNull String description;
    private boolean isMaliGpuDetected;
    private @NonNull Optional<@NonNull RunAsInfo> runAsInfo;

    public AndroidTargetDevice(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IAndroidTargetDevice.Status status, @NonNull TargetAddressString targetAddress, @NonNull String description, @NonNull AdbDeviceRootMode deviceRootMode) {
        this(status, targetAddress, description, Optional.empty(), deviceRootMode, false);
    }

    public AndroidTargetDevice(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IAndroidTargetDevice.Status status, @NonNull TargetAddressString targetAddress, @NonNull String description, @NonNull Optional<@NonNull RunAsInfo> runAsInfo, @NonNull AdbDeviceRootMode deviceRootMode, boolean isMaliGpuDetected) {
        if (targetAddress.isTcp()) {
            throw new AssertionError((Object)("A TCP target address was given in a context where an address for an ADB device was expected: " + String.valueOf(targetAddress)));
        }
        if (!targetAddress.isValid()) {
            throw new AssertionError((Object)("An invalid target address was given: '" + String.valueOf(targetAddress) + "'"));
        }
        this.deviceRootMode = deviceRootMode;
        this.status.set((Object)status);
        this.targetAddress = targetAddress;
        this.description = description;
        this.runAsInfo = runAsInfo;
        this.tooltipProperty = new SimpleStringProperty(this.getTooltip());
        this.isMaliGpuDetected = isMaliGpuDetected;
    }

    public @NonNull String getDescription() {
        return this.description;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IAndroidTargetDevice.Status getStatus() {
        return (IAndroidTargetDevice.Status)this.status.get();
    }

    public @NonNull ObservableValue<// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IAndroidTargetDevice.Status> statusProperty() {
        return this.status;
    }

    public @NonNull ObservableStringValue tooltipProperty() {
        return this.tooltipProperty;
    }

    public @NonNull String getTargetAddress() {
        return this.targetAddress.toString();
    }

    public @NonNull String getSerialNumber() {
        return this.targetAddress.getAndroidSerialNumber();
    }

    public @NonNull String getTooltip() {
        switch ((IAndroidTargetDevice.Status)this.status.get()) {
            case AVAILABLE: {
                return "The device is available for use";
            }
            case UNAUTHORIZED: {
                return "The device is unauthorized so cannot be used";
            }
            case UNAVAILABLE_GATORD_RUNNING: {
                @NonNull String message = String.format("%s%n%s", "Gatord is running on this device, but was not configured by Streamline.", "Use the TCP(Advanced) option, or allow Streamline to stop it and assume control of the device.");
                return message;
            }
            case UNAVAILABLE_INVALID_VERSION_KILLABLE: 
            case UNAVAILABLE_INVALID_VERSION_UNKILLABLE: {
                return "The device is detected as using an incompatible version of gatord so cannot be used";
            }
            case UNAVAILABLE_OTHER: {
                return "The device is not supported";
            }
            case AVAILABLE_GATORD_RUNNING_PACKAGE: {
                return String.format("Gatord is running as package %s", this.runAsInfo.get().getWaitProcessCommand());
            }
            case AVAILABLE_BUT_OUTDATED_CONFIGURATION_XML: {
                @NonNull String outdatedConfigurationMessage = String.format("%s%n%s", "The device has been configured with a different version of Streamline.", "Re-configure the device with the current version.");
                return outdatedConfigurationMessage;
            }
        }
        throw new AssertionError(this.status);
    }

    public void acceptChangesFrom(@NonNull IAndroidTargetDevice otherDevice) {
        if (!this.targetAddress.toString().equals(otherDevice.getTargetAddress())) {
            throw new AssertionError((Object)("update must not be for some other device, original: " + String.valueOf(this.targetAddress) + " update: " + otherDevice.getTargetAddress()));
        }
        this.deviceRootMode = otherDevice.getDeviceRootMode();
        this.runAsInfo = otherDevice.getRunAsInfo();
        this.description = otherDevice.getDescription();
        this.isMaliGpuDetected = otherDevice.isMaliGpuDetected();
        this.status.set((Object)otherDevice.getStatus());
        this.tooltipProperty.set(otherDevice.getTooltip());
    }

    public int hashCode() {
        return 31 + this.targetAddress.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AndroidTargetDevice other = (AndroidTargetDevice)obj;
        return this.targetAddress.equals(other.targetAddress);
    }

    public String toString() {
        return "AndroidTargetDevice [status=" + String.valueOf(this.status) + ", targetAddress=" + String.valueOf(this.targetAddress) + ", description=" + this.description + ", deviceRootMode=" + String.valueOf(this.deviceRootMode) + "]";
    }

    public @NonNull Optional<@NonNull RunAsInfo> getRunAsInfo() {
        return this.runAsInfo;
    }

    public @NonNull AdbDeviceRootMode getDeviceRootMode() {
        return this.deviceRootMode;
    }

    public boolean isMaliGpuDetected() {
        return this.isMaliGpuDetected;
    }
}

