/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.section;

import com.arm.streamline.performanceadvisor.section.ElementType;
import com.arm.streamline.performanceadvisor.section.JsonReportElement;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Element {
    protected final ElementType type;
    private boolean excludeFromJson;
    private boolean excludeFromHtml;
    private boolean excludeFromCsv;

    public Element(ElementType type) {
        this.type = type;
        this.excludeFromHtml = false;
        this.excludeFromJson = false;
        this.excludeFromCsv = true;
    }

    public ElementType getElementType() {
        return this.type;
    }

    public void setExcludeFromHtml(boolean newValue) {
        this.excludeFromHtml = newValue;
    }

    public void setExcludeFromJson(boolean newValue) {
        this.excludeFromJson = newValue;
    }

    public void setExcludeFromCsv(boolean newValue) {
        this.excludeFromCsv = newValue;
    }

    public boolean getExcludeFromHtml() {
        return this.excludeFromHtml;
    }

    public boolean getExcludeFromJson() {
        return this.excludeFromJson;
    }

    public boolean getExcludeFromCsv() {
        return this.excludeFromCsv;
    }

    public Map<String, ?> asMap() {
        throw new UnsupportedOperationException("Method addToJson not implemented for " + this.getClass().getCanonicalName());
    }

    protected static String formatPropertyName(String name) {
        if (name != null && name.length() > 0) {
            name = name.replace("(%)", "Percentage");
            Pattern unformatted = Pattern.compile("[^a-zA-Z_\\d\\$]");
            Matcher matcher = unformatted.matcher(name);
            char c = name.charAt(0);
            if (matcher.find() || Character.isUpperCase(c) || Character.isDigit(c)) {
                name = Element.formatForJsonCompatibility(name);
            }
        }
        return name;
    }

    private static String formatForJsonCompatibility(String str) {
        StringBuilder builder = new StringBuilder();
        boolean isWordBoundary = false;
        boolean isFirstCharacter = true;
        char[] cArray = str.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isSpaceChar(c)) {
                isWordBoundary = true;
            } else if (c == '$' || c == '_') {
                builder.append(c);
            } else if (Character.isLetter(c)) {
                c = isWordBoundary && !isFirstCharacter ? Character.toTitleCase(c) : Character.toLowerCase(c);
                isFirstCharacter = false;
                isWordBoundary = false;
                builder.append(c);
            } else if (Character.isDigit(c) && !isFirstCharacter) {
                isWordBoundary = false;
                builder.append(c);
            }
            ++n2;
        }
        return builder.toString();
    }

    public JsonReportElement<? extends Element> asJsonReportElement() {
        throw new UnsupportedOperationException("Method asJsonReportElement not implemented for " + this.getClass().getCanonicalName());
    }
}

