/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.renderer;

import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.common.FatalError;
import com.arm.streamline.performanceadvisor.json.JsonDoubleSerialiser;
import com.arm.streamline.performanceadvisor.renderer.GsonExclusionStrategy;
import com.arm.streamline.performanceadvisor.renderer.Renderer;
import com.arm.streamline.performanceadvisor.renderer.RendererOptions;
import com.arm.streamline.performanceadvisor.section.BarChart;
import com.arm.streamline.performanceadvisor.section.DualAxisLineChart;
import com.arm.streamline.performanceadvisor.section.Element;
import com.arm.streamline.performanceadvisor.section.ElementGroup;
import com.arm.streamline.performanceadvisor.section.GaugeChart;
import com.arm.streamline.performanceadvisor.section.LineChart;
import com.arm.streamline.performanceadvisor.section.Section;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JsonRenderer
implements Renderer {
    RendererOptions rendererOptions;
    Gson gson;

    public JsonRenderer(RendererOptions rendererOptions) {
        this.rendererOptions = rendererOptions;
        GsonBuilder builder = new GsonBuilder().serializeNulls();
        if (rendererOptions.prettyPrintJson()) {
            builder.setPrettyPrinting();
        }
        builder.registerTypeAdapter(Double.class, (Object)new JsonDoubleSerialiser());
        builder.addSerializationExclusionStrategy((ExclusionStrategy)new GsonExclusionStrategy());
        this.gson = builder.create();
    }

    @Override
    public void render(List<Section> sections, Path destination) throws IOException {
        JsonObject reportJson = new JsonObject();
        for (Section section : sections) {
            reportJson.add(section.getName(), (JsonElement)this.generateJsonObjectFromElements(section.getElements()));
        }
        JsonObject filteredJson = this.filterJsonForRegions(reportJson);
        JsonObject removedEmptyJson = this.removeEmptyJson(filteredJson);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(destination.toFile()), StandardCharsets.UTF_8));){
                writer.write(this.gson.toJson((JsonElement)removedEmptyJson));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (UnsupportedEncodingException e) {
            Application.LOG.severe(e.getMessage());
            throw new FatalError("Error when encoding report to JSON.");
        }
    }

    private JsonObject generateJsonObjectFromElements(List<Element> sectionElements) {
        JsonObject sectionJson = new JsonObject();
        for (Element sectionElement : sectionElements) {
            if (sectionElement.getExcludeFromJson()) continue;
            try {
                this.appendJson(sectionJson, this.gson.toJsonTree(sectionElement.asMap()).getAsJsonObject());
            }
            catch (UnsupportedOperationException ex) {
                switch (sectionElement.getElementType()) {
                    case LINE: {
                        LineChart lineSectionElement = (LineChart)sectionElement;
                        this.appendJson(sectionJson, this.gson.toJsonTree(lineSectionElement.asMap(this.rendererOptions.getCentiles())).getAsJsonObject());
                        break;
                    }
                    case DUAL_AXIS: {
                        DualAxisLineChart dualLineSectionElement = (DualAxisLineChart)sectionElement;
                        this.appendJson(sectionJson, this.gson.toJsonTree(dualLineSectionElement.asMap(this.rendererOptions.getCentiles())).getAsJsonObject());
                        break;
                    }
                    case GROUP: {
                        ElementGroup groupSectionElement = (ElementGroup)sectionElement;
                        JsonObject groupJson = this.renderGroup(groupSectionElement);
                        this.appendJson(sectionJson, groupJson);
                        break;
                    }
                    case INTERACTIVE: {
                        this.appendJson(sectionJson, this.gson.toJsonTree(sectionElement.asJsonReportElement()).getAsJsonObject());
                        break;
                    }
                    default: {
                        Application.LOG.info("Not processing json for element " + String.valueOf((Object)sectionElement.getElementType()));
                    }
                }
            }
        }
        return sectionJson;
    }

    private JsonObject renderGroup(ElementGroup groupElement) {
        JsonObject groupJsonObject = new JsonObject();
        for (Element elementInGroup : groupElement.getElements()) {
            switch (elementInGroup.getElementType()) {
                case GAUGE: {
                    GaugeChart gaugeChartElement = (GaugeChart)elementInGroup;
                    this.appendJson(groupJsonObject, this.gson.toJsonTree((Object)gaugeChartElement.asMap()).getAsJsonObject());
                    break;
                }
                case BAR: {
                    BarChart barChartElement = (BarChart)elementInGroup;
                    this.appendJson(groupJsonObject, this.gson.toJsonTree((Object)barChartElement.asMap()).getAsJsonObject());
                    break;
                }
                default: {
                    Application.LOG.info("Not processing json for element in group " + String.valueOf((Object)elementInGroup.getElementType()));
                }
            }
        }
        return groupJsonObject;
    }

    private void appendJson(JsonObject dest, JsonObject src) {
        for (Map.Entry entry : src.entrySet()) {
            dest.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
    }

    JsonObject filterJsonForRegions(JsonObject reportJson) {
        ArrayList<JsonObject> regionListJson = new ArrayList<JsonObject>();
        ArrayList<String> sectionsToRemove = new ArrayList<String>();
        for (Map.Entry reportJsonEntry : reportJson.entrySet()) {
            if (!((String)reportJsonEntry.getKey()).endsWith("_summary")) continue;
            String regionName = ((String)reportJsonEntry.getKey()).substring(0, ((String)reportJsonEntry.getKey()).length() - 8);
            JsonObject regionJson = new JsonObject();
            regionJson.addProperty("name", regionName);
            for (Map.Entry otherEntry : reportJson.entrySet()) {
                if (!((String)otherEntry.getKey()).startsWith(regionName)) continue;
                sectionsToRemove.add((String)otherEntry.getKey());
                String filteredSectionName = ((String)otherEntry.getKey()).substring(((String)otherEntry.getKey()).lastIndexOf(95) + 1);
                regionJson.add(filteredSectionName, (JsonElement)otherEntry.getValue());
            }
            regionListJson.add(regionJson);
        }
        JsonObject removedJson = new JsonObject();
        for (Map.Entry entry : reportJson.entrySet()) {
            if (sectionsToRemove.contains(entry.getKey())) continue;
            removedJson.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
        removedJson.add("regions", this.gson.toJsonTree(regionListJson));
        return removedJson;
    }

    JsonObject removeEmptyJson(JsonObject reportJson) {
        JsonObject removedJson = new JsonObject();
        for (Map.Entry entry : reportJson.entrySet()) {
            if (((JsonElement)entry.getValue()).toString().equals("{}") || ((JsonElement)entry.getValue()).toString().equals("[]")) continue;
            removedJson.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
        return removedJson;
    }
}

