/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.renderer;

import com.arm.streamline.performanceadvisor.common.FatalError;
import com.arm.streamline.performanceadvisor.renderer.GsonExclusionStrategy;
import com.arm.streamline.performanceadvisor.renderer.Renderer;
import com.arm.streamline.performanceadvisor.section.Element;
import com.arm.streamline.performanceadvisor.section.Section;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Scanner;
import org.eclipse.jdt.annotation.Checks;
import org.jsoup.Jsoup;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;

public class HtmlRenderer
implements Renderer {
    private Properties properties;
    private static final String MEERKAT_JSON_DATA_ID = "meerkatData";
    private static final String SCRIPT_ELEMENT = "script";

    public HtmlRenderer() {
        this(HtmlRenderer.getDefaultProperties());
    }

    public HtmlRenderer(Properties properties) {
        this.properties = properties;
    }

    private static Properties getDefaultProperties() {
        Properties properties = new Properties();
        properties.setProperty("JQUERY_PATH", "/jquery-3.3.1.min.js");
        properties.setProperty("D3_JS_PATH", "/d3.v5.min.js");
        properties.setProperty("BILLBOARD_JS_PATH", "/billboard.min.js");
        properties.setProperty("BILLBOARD_CSS_PATH", "/billboard.min.css");
        properties.setProperty("CALIPERS_JS_PATH", "/billboardjs-plugin-calipers.min.js");
        properties.setProperty("MEERKAT_TEMPLATE_PATH", "/meerkat-template.html");
        properties.setProperty("MEERKAT_MAIN_JS_PATH", "/meerkat-main.js");
        properties.setProperty("MEERKAT_CSS_PATH", "/meerkat-style.css");
        properties.setProperty("MEERKAT_HELPER_JS_PATH", "/meerkat-helper.js");
        return properties;
    }

    @Override
    public void render(List<Section> sections, Path destination) throws IOException {
        File outputFile = destination.toFile();
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Section section : sections) {
            elements.addAll(section.getElements());
        }
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        builder.addSerializationExclusionStrategy((ExclusionStrategy)new GsonExclusionStrategy());
        Gson gson = builder.create();
        String html = this.loadResourceById("MEERKAT_TEMPLATE_PATH");
        Document doc = (Document)Checks.requireNonNull((Object)Jsoup.parse((String)html));
        this.addJsonData(doc, (String)Checks.requireNonNull((Object)gson.toJson(elements)), MEERKAT_JSON_DATA_ID);
        this.addStyleResourceById(doc, "MEERKAT_CSS_PATH");
        this.addStyleResourceById(doc, "BILLBOARD_CSS_PATH");
        this.addJavaScriptResourceById(doc, "D3_JS_PATH", "head");
        this.addJavaScriptResourceById(doc, "BILLBOARD_JS_PATH", "head");
        this.addJavaScriptResourceById(doc, "CALIPERS_JS_PATH", "head");
        this.addJavaScriptResourceById(doc, "JQUERY_PATH", "head");
        this.addJavaScriptResourceById(doc, "MEERKAT_HELPER_JS_PATH", "body");
        this.addJavaScriptResourceById(doc, "MEERKAT_MAIN_JS_PATH", "body");
        Throwable throwable = null;
        Object var10_11 = null;
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile));){
            writer.write(doc.toString());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    String loadResourceById(String pathPropertyId) {
        return this.loadResource(this.properties.getProperty(pathPropertyId));
    }

    String loadResource(String path) {
        InputStream stream = HtmlRenderer.class.getResourceAsStream("/resources/performanceadvisor" + path);
        if (stream == null) {
            throw new NullPointerException("Could not get path /resources/performanceadvisor" + path);
        }
        Scanner scan = new Scanner(stream);
        scan.useDelimiter("\\A");
        String output = "";
        if (!scan.hasNext()) {
            scan.close();
            throw new FatalError("Failed to load template");
        }
        output = scan.next();
        scan.close();
        return output;
    }

    void addJavaScriptResourceById(Document doc, String jsPropertyId, String domLocation) {
        String jsResourcePath = this.properties.getProperty(jsPropertyId);
        doc.selectFirst(domLocation).appendElement(SCRIPT_ELEMENT).appendChild((Node)new DataNode(this.loadResource(jsResourcePath)));
    }

    void addStyleResourceById(Document doc, String cssResourcePathId) {
        String cssResourcePath = this.properties.getProperty(cssResourcePathId);
        doc.selectFirst("head").appendElement("style").appendChild((Node)new DataNode(this.loadResource(cssResourcePath)));
    }

    void addJsonData(Document doc, String data, String elementId) {
        doc.selectFirst("head").appendElement(SCRIPT_ELEMENT).attr("id", elementId).attr("type", "application/json").appendChild((Node)new DataNode(data));
    }
}

