/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.renderer;

import com.arm.streamline.performanceadvisor.common.LogicError;
import com.arm.streamline.performanceadvisor.renderer.CsvTable;
import com.arm.streamline.performanceadvisor.section.PartialColumnList;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public class CsvTableBuilder {
    private final @NonNull List<@NonNull PartialColumnList> columnList = new ArrayList<PartialColumnList>();

    public void append(@NonNull PartialColumnList newCols) {
        if (!this.columnList.isEmpty()) {
            @NonNull PartialColumnList firstList = this.columnList.get(0);
            if (!firstList.getFrames().equals(newCols.getFrames())) {
                throw new LogicError("Frame data is not identical when composing Csv table ");
            }
            if (firstList.getStartFrameIndex() != newCols.getStartFrameIndex()) {
                throw new LogicError("Start frame index does not match for all data columns");
            }
        }
        this.columnList.add(newCols);
    }

    public @NonNull CsvTable build() {
        return new CsvTable(this.columnList);
    }
}

