/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.json;

import com.arm.streamline.performanceadvisor.json.CaptureInfo;
import com.arm.streamline.performanceadvisor.json.DualAxisChartJsonListDeserialiser;
import com.arm.streamline.performanceadvisor.json.JsonRegionListDeserialiser;
import com.arm.streamline.performanceadvisor.json.JsonRegionSection;
import com.arm.streamline.performanceadvisor.json.JsonReport;
import com.arm.streamline.performanceadvisor.json.JsonSection;
import com.arm.streamline.performanceadvisor.section.DualAxisChartJson;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class JsonReportDeserialiser
implements JsonDeserializer<JsonReport> {
    private static final String REGIONS_KEY = "regions";
    private static final Type JSON_REGION_SECTION_LIST_TYPE = new TypeToken<List<JsonRegionSection>>(){}.getType();
    private static final Type DUAL_AXIS_CHART_JSON_LIST_TYPE = new TypeToken<List<DualAxisChartJson>>(){}.getType();
    Gson gson;

    public JsonReportDeserialiser() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(JSON_REGION_SECTION_LIST_TYPE, (Object)new JsonRegionListDeserialiser());
        gsonBuilder.registerTypeAdapter(DUAL_AXIS_CHART_JSON_LIST_TYPE, (Object)new DualAxisChartJsonListDeserialiser());
        this.gson = gsonBuilder.create();
    }

    public JsonReport deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) {
        JsonObject jsonReportJsonObject = jsonElement.getAsJsonObject();
        List reportRegions = null;
        JsonElement regionsJsonElement = jsonReportJsonObject.get(REGIONS_KEY);
        if (regionsJsonElement != null) {
            reportRegions = (List)this.gson.fromJson(regionsJsonElement, JSON_REGION_SECTION_LIST_TYPE);
        }
        ArrayList<JsonSection> reportSections = new ArrayList<JsonSection>();
        for (String sectionName : jsonReportJsonObject.keySet()) {
            JsonObject sectionJsonObject;
            List sectionElements;
            JsonElement sectionJsonElement = jsonReportJsonObject.get(sectionName);
            if (!sectionJsonElement.isJsonObject() || (sectionElements = (List)this.gson.fromJson((JsonElement)(sectionJsonObject = sectionJsonElement.getAsJsonObject()), DUAL_AXIS_CHART_JSON_LIST_TYPE)).isEmpty()) continue;
            reportSections.add(new JsonSection(sectionName, sectionElements));
        }
        JsonElement captureInfoJson = jsonReportJsonObject.get("captureInfo");
        if (captureInfoJson == null) {
            throw new JsonParseException("Not a PA json report.");
        }
        CaptureInfo captureInfo = (CaptureInfo)this.gson.fromJson(captureInfoJson, CaptureInfo.class);
        return new JsonReport(reportSections, reportRegions, captureInfo);
    }
}

