/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.json;

import com.arm.streamline.performanceadvisor.json.JsonRegionSection;
import com.arm.streamline.performanceadvisor.json.JsonSection;
import com.arm.streamline.performanceadvisor.json.JsonSectionListDeserialiser;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class JsonRegionListDeserialiser
implements JsonDeserializer<List<JsonRegionSection>> {
    private static final Type JSON_SECTION_LIST_TYPE = new TypeToken<List<JsonSection>>(){}.getType();
    Gson gson;

    public JsonRegionListDeserialiser() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(JSON_SECTION_LIST_TYPE, (Object)new JsonSectionListDeserialiser());
        this.gson = gsonBuilder.create();
    }

    public List<JsonRegionSection> deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) {
        if (!jsonElement.isJsonArray()) {
            throw new JsonParseException("Invalid regions json.");
        }
        ArrayList<JsonRegionSection> regions = new ArrayList<JsonRegionSection>();
        JsonArray regionsJsonArray = jsonElement.getAsJsonArray();
        for (JsonElement regionJsonElement : regionsJsonArray) {
            List regionSections = (List)this.gson.fromJson(regionJsonElement, JSON_SECTION_LIST_TYPE);
            String regionName = regionJsonElement.getAsJsonObject().get("name").getAsString();
            JsonRegionSection jsonRegionSection = new JsonRegionSection(regionName, regionSections);
            regions.add(jsonRegionSection);
        }
        return regions;
    }
}

