/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.json;

import com.arm.streamline.performanceadvisor.section.DualAxisChartJson;
import com.arm.streamline.performanceadvisor.section.JsonLineMetric;
import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class DualAxisChartJsonListDeserialiser
implements JsonDeserializer<List<DualAxisChartJson>> {
    Gson gson = new Gson();

    public List<DualAxisChartJson> deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) {
        ArrayList<DualAxisChartJson> sectionElements = new ArrayList<DualAxisChartJson>();
        JsonObject dualAxisChartJsonObject = jsonElement.getAsJsonObject();
        for (String chartName : dualAxisChartJsonObject.keySet()) {
            JsonElement dualAxisChartJsonElement = dualAxisChartJsonObject.get(chartName);
            if (dualAxisChartJsonElement.isJsonPrimitive()) continue;
            JsonLineMetric dualAxisJsonLineMetric = null;
            try {
                dualAxisJsonLineMetric = (JsonLineMetric)this.gson.fromJson(dualAxisChartJsonElement, JsonLineMetric.class);
            }
            catch (JsonSyntaxException | NumberFormatException e) {
                throw new JsonParseException("Invalid JSON for dual axis chart.");
            }
            if (dualAxisJsonLineMetric == null || dualAxisJsonLineMetric.getCentiles() == null) continue;
            DualAxisChartJson dualAxisChartJson = new DualAxisChartJson(chartName, dualAxisJsonLineMetric);
            sectionElements.add(dualAxisChartJson);
        }
        return sectionElements;
    }
}

