/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.io;

import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.common.FatalError;
import com.arm.streamline.performanceadvisor.io.IFileReaderFactory;
import com.arm.streamline.performanceadvisor.io.UserProvidedPath;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;

public class JsonFilesReader {
    private JsonFilesReader() {
        throw new IllegalStateException("JsonFilesReader should not be instantiated");
    }

    public static <T> T read(Gson gson, UserProvidedPath path, Class<T> classOfT, IFileReaderFactory fileReaderFactory) {
        Application.LOG.info(() -> "Reading json file from " + String.valueOf(path));
        Path userPath = path.getUserProvidedPath();
        try {
            Throwable throwable = null;
            Object var6_10 = null;
            try (Reader reader = fileReaderFactory.createReader(path.getAdjustedPath());){
                return (T)gson.fromJson(reader, classOfT);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioException) {
            throw JsonFilesReader.fatalError(ioException, userPath);
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            throw JsonFilesReader.fatalError(jsonSyntaxException, userPath);
        }
        catch (JsonParseException jsonParseException) {
            throw JsonFilesReader.fatalError(jsonParseException, userPath);
        }
    }

    private static FatalError fatalError(JsonParseException exception, Path userPath) {
        String errorMessage = String.format("Error parsing %s%n%s", userPath, exception.getMessage());
        return JsonFilesReader.fatalError(errorMessage, exception);
    }

    private static FatalError fatalError(JsonSyntaxException exception, Path userPath) {
        String errorMessage = String.format("Syntax error in %s%n%s", userPath, exception.getCause().getMessage());
        return JsonFilesReader.fatalError(errorMessage, exception);
    }

    private static FatalError fatalError(IOException exception, Path userPath) {
        String errorMessage = String.format("Failed to load %s%n%s", userPath, exception.getMessage());
        return JsonFilesReader.fatalError(errorMessage, exception);
    }

    private static FatalError fatalError(String errorMessage, Throwable cause) {
        return new FatalError(errorMessage, cause);
    }
}

