/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.developer;

import com.arm.streamline.performanceadvisor.analyser.Analyser;
import com.arm.streamline.performanceadvisor.analyser.AnalyserFactory;
import com.arm.streamline.performanceadvisor.analyser.BinnedData;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.section.Element;
import com.arm.streamline.performanceadvisor.section.LineChart;
import com.arm.streamline.performanceadvisor.section.Section;
import com.arm.streamline.performanceadvisor.section.TextBlock;
import com.arm.streamline.performanceadvisor.section.TextStyle;
import java.util.ArrayList;

public class BinningTestAnalyserFactory
extends AnalyserFactory {
    @Override
    public Analyser create(CaptureData captureData) {
        return new BinningTestAnalyser(captureData);
    }

    public class BinningTestAnalyser
    extends Analyser {
        public BinningTestAnalyser(CaptureData captureData) {
            super(captureData);
        }

        @Override
        public Section execute(int userRegion) {
            int[] testBinSizes;
            ArrayList<Element> elements = new ArrayList<Element>();
            elements.add(new TextBlock(TextStyle.H2_HIDDEN, "Binning test", "Test of the binning functionality used for per-frame charts. Uses the JS1 non-fragment activity counter, limited to the first 10s of the capture."));
            int range = 10000;
            double[] timeData = new double[range];
            int i = 0;
            while (i < timeData.length) {
                timeData[i] = i;
                ++i;
            }
            elements.add(new TextBlock(TextStyle.H2_HIDDEN, "Streamline source data"));
            elements.add(new TextBlock(TextStyle.DESCRIPTION, "1ms binned"));
            elements.add(new TextBlock(TextStyle.H2_HIDDEN, "PA binned versions"));
            int samplesPerSecond = this.captureData.getSamplesPerSecond();
            int[] nArray = testBinSizes = new int[]{1, 2, 5, 10, 20, 50, 100, 150, 200};
            int n = testBinSizes.length;
            int n2 = 0;
            while (n2 < n) {
                int binSize = nArray[n2];
                BinnedData binnedData = new BinnedData(binSize, samplesPerSecond, 0.0);
                elements.add(new TextBlock(TextStyle.DESCRIPTION, String.format("%.0fms bins", binnedData.getBinDurationMs())));
                elements.add(new LineChart("Time (s)", binnedData.getName(0), binnedData.getTimes(), binnedData.getSeries(0), "overall"));
                ++n2;
            }
            return new Section("binningTest", elements);
        }
    }
}

