/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.counterseries;

import com.arm.streamline.common.model.counters.CounterDisplay;
import com.arm.streamline.model.capture.ISeriesDataProvider;
import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.counterseries.ExpressionSeries;
import com.arm.streamline.performanceadvisor.counterseries.SummationSeries;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class WildcardExpressionSeries
extends SummationSeries {
    private static final String SERIES_NOT_FOUND_LOG = "Series \"%s\" provided by wildcard expression %s could not be found.";
    private @NonNull String expression;
    private @Nullable String units;
    private boolean isAverage;
    private boolean isPerFrame;
    private boolean isMax;
    private boolean isMin;
    private boolean doNotShowIfAllZeroes;

    public WildcardExpressionSeries(@NonNull String name, @NonNull String expression, @Nullable String units, boolean isAverage, boolean isPerFrame, boolean isMax, boolean isMin, boolean doNotShowIfAllZeroes) {
        super(name);
        this.expression = expression;
        this.units = units;
        this.isAverage = isAverage;
        this.isPerFrame = isPerFrame;
        this.isMax = isMax;
        this.isMin = isMin;
        this.doNotShowIfAllZeroes = doNotShowIfAllZeroes;
    }

    @Override
    public ProblemList initialise(CaptureData captureData) {
        @NonNull List<@NonNull ISeriesDataProvider> sourceList = captureData.getSeriesForWildcardExpression(this.expression, this.units);
        ProblemList problems = new ProblemList();
        String name = this.getName();
        if (!sourceList.isEmpty()) {
            for (ISeriesDataProvider src : sourceList) {
                this.addComponent(new ContextExpressionSeries(name, this.expression, this.units, this.isAverage, this.isPerFrame, this.isMax, this.isMin, this.doNotShowIfAllZeroes, src));
            }
        } else {
            problems.addWarning(String.format("The series \"%s\" could not be found. Ensure that you are analysing a capture made with a matching version of Streamline and that all the expression values in your report configuration are correct.", name));
            Application.LOG.warning(String.format(SERIES_NOT_FOUND_LOG, name, this.expression));
        }
        problems.addAll(super.initialise(captureData));
        return problems;
    }

    @Override
    public boolean isAverage() {
        return this.isAverage;
    }

    @Override
    public boolean isPerFrame() {
        return this.isPerFrame;
    }

    @Override
    public boolean isMaximum() {
        return this.isMax;
    }

    @Override
    public boolean isMinimum() {
        return this.isMin;
    }

    @Override
    public boolean doNotShowIfAllZeroes() {
        return this.doNotShowIfAllZeroes;
    }

    private class ContextExpressionSeries
    extends ExpressionSeries {
        private @NonNull ISeriesDataProvider provider;

        public ContextExpressionSeries(@NonNull String name, @Nullable String expression, String units, boolean isAverage, boolean isPerFrame, boolean isMax, boolean isMin, @NonNull boolean doNotShowIfAllZeroes, ISeriesDataProvider provider) {
            super(name, expression, units, isAverage, isPerFrame, isMax, isMin, doNotShowIfAllZeroes);
            this.provider = provider;
        }

        @Override
        protected @Nullable ISeriesDataProvider initialiseDataSource(CaptureData captureData) {
            if (WildcardExpressionSeries.this.isAverage) {
                this.provider.getConfig().setDisplay(CounterDisplay.AVERAGE);
            }
            if (WildcardExpressionSeries.this.isMax) {
                this.provider.getConfig().setDisplay(CounterDisplay.MAXIMUM);
            }
            if (WildcardExpressionSeries.this.isMin) {
                this.provider.getConfig().setDisplay(CounterDisplay.MINIMUM);
            }
            return this.provider;
        }
    }
}

