/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.counterseries;

import com.arm.streamline.performanceadvisor.counterseries.CounterDescriptor;
import com.arm.streamline.performanceadvisor.counterseries.StreamlineSeries;
import java.lang.ref.SoftReference;
import java.util.OptionalInt;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ShaderCoreSeries
extends StreamlineSeries {
    private @Nullable SoftReference<double @NonNull []> cachedResult;
    private final int shaderCoreCount;

    public ShaderCoreSeries(@NonNull CounterDescriptor descriptor, boolean isOptional, OptionalInt shaderCoreCount) {
        super(descriptor, isOptional, false);
        this.shaderCoreCount = Math.max(1, shaderCoreCount.orElse(1));
    }

    @Override
    public double @NonNull [] toArray() {
        return ShaderCoreSeries.cacheValue(this.cachedResult, r -> {
            SoftReference softReference = this.cachedResult = r;
        }, () -> {
            double[] data = super.toArray();
            if (this.shaderCoreCount <= 1) {
                return data;
            }
            double[] result = new double[data.length];
            int i = 0;
            while (i < data.length) {
                result[i] = data[i] / (double)this.shaderCoreCount;
                ++i;
            }
            return result;
        });
    }
}

