/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.counterseries;

import com.arm.streamline.model.capture.ISeriesDataProvider;
import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.common.LogicError;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.common.StringUtils;
import com.arm.streamline.performanceadvisor.counterseries.BasicSeries;
import java.lang.ref.SoftReference;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.RGB;

public abstract class DataProviderSeries
extends BasicSeries {
    private @Nullable SoftReference<double @NonNull []> cachedResult;
    private @Nullable ISeriesDataProvider dataSource = null;
    private int length = 0;

    public DataProviderSeries(@NonNull String name) {
        super(name);
    }

    @Override
    public String getColour() {
        ISeriesDataProvider dataSource = this.dataSource;
        if (dataSource != null) {
            RGB colour = dataSource.getConfig().getColor();
            return StringUtils.rgbToHexString(colour);
        }
        return "";
    }

    public @Nullable ISeriesDataProvider getDataSource() {
        return this.dataSource;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public ProblemList initialise(CaptureData captureData) {
        ISeriesDataProvider dataSource = this.initialiseDataSource(captureData);
        if (dataSource != this.dataSource) {
            if (dataSource != null) {
                this.dataSource = dataSource;
                this.length = captureData.getBinCount();
                this.cachedResult = null;
            } else {
                Application.LOG.fine("ISeriesDataProvider not found for counter series: " + this.getName());
                this.dataSource = null;
                this.length = 0;
                this.cachedResult = null;
            }
        }
        return this.getProblems();
    }

    @Override
    public boolean isPresent() {
        return this.dataSource != null;
    }

    @Override
    public double @NonNull [] toArray() {
        ISeriesDataProvider dataSource = this.dataSource;
        if (dataSource == null) {
            throw new LogicError(String.format("No data for series %s", this.getName()));
        }
        return DataProviderSeries.cacheValue(this.cachedResult, r -> {
            SoftReference softReference = this.cachedResult = r;
        }, () -> {
            dataSource.refreshWarnings();
            String warning = dataSource.getWarning();
            ISeriesDataProvider.WarningSource warningSource = dataSource.getWarningSource();
            assert (warning == null && warningSource == ISeriesDataProvider.WarningSource.NONE) : String.format("Unexpected data source warning: %s: %s", new Object[]{warningSource, warning});
            double[] result = dataSource.getData(0, this.length - 1, null);
            if (result == null) {
                result = new double[this.length];
            }
            return result;
        });
    }

    protected @NonNull ProblemList getProblems() {
        return new ProblemList();
    }

    protected abstract @Nullable ISeriesDataProvider initialiseDataSource(CaptureData var1);
}

