/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.counterseries;

import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.common.LogicError;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.counterseries.BasicSeries;
import com.arm.streamline.performanceadvisor.counterseries.CounterSeries;
import java.lang.ref.SoftReference;
import java.util.function.DoubleBinaryOperator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class BinaryOpSeries
extends BasicSeries {
    private final @NonNull DoubleBinaryOperator fn;
    private final @NonNull CounterSeries lhs;
    private final @NonNull CounterSeries rhs;
    private @Nullable SoftReference<double @NonNull []> cachedResult;

    private static double @NonNull [] apply(@NonNull DoubleBinaryOperator fn, double @NonNull [] lhs, double @NonNull [] rhs, @NonNull String name) {
        if (lhs.length != rhs.length) {
            throw new LogicError("Incompatible arguments to BinaryOpSeries " + name);
        }
        double[] result = new double[lhs.length];
        int i = 0;
        while (i < result.length) {
            result[i] = fn.applyAsDouble(lhs[i], rhs[i]);
            ++i;
        }
        return result;
    }

    public BinaryOpSeries(@NonNull CounterSeries lhs, @NonNull CounterSeries rhs, @NonNull String name, @NonNull DoubleBinaryOperator fn) {
        super(name);
        this.lhs = lhs;
        this.rhs = rhs;
        this.fn = fn;
        Application.LOG.finest(() -> String.format("New BinaryOpSeries %s for \"%s\" and \"%s\"", name, lhs.getName(), rhs.getName()));
    }

    @Override
    public int getLength() {
        return this.lhs.getLength();
    }

    @Override
    public ProblemList initialise(CaptureData captureData) {
        ProblemList problems = new ProblemList();
        problems.addAll(this.lhs.initialise(captureData));
        problems.addAll(this.rhs.initialise(captureData));
        if (!problems.hasError() && this.lhs.getLength() != this.rhs.getLength()) {
            throw new LogicError(String.format("BinaryOpSeries: component series must be the same length (have %d, %d)", this.lhs.getLength(), this.rhs.getLength()));
        }
        Application.LOG.finest(() -> String.format("BinaryOpSeries: series length is %d", this.getLength()));
        if (this.lhs.isPerFrame() != this.rhs.isPerFrame()) {
            throw new LogicError("BinaryOpSeries: incompatible series");
        }
        return problems;
    }

    @Override
    public boolean isPerFrame() {
        return this.lhs.isPerFrame();
    }

    @Override
    public boolean isPresent() {
        return this.lhs.isPresent() && this.rhs.isPresent();
    }

    @Override
    public double @NonNull [] toArray() {
        if (!this.isPresent()) {
            throw new LogicError("No data for series " + this.getName());
        }
        return BinaryOpSeries.cacheValue(this.cachedResult, r -> {
            SoftReference softReference = this.cachedResult = r;
        }, () -> BinaryOpSeries.apply(this.fn, this.lhs.toArray(), this.rhs.toArray(), this.getName()));
    }
}

