/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.counterseries;

import com.arm.streamline.performanceadvisor.common.LogicError;
import com.arm.streamline.performanceadvisor.counterseries.BasicSeries;
import org.eclipse.jdt.annotation.NonNull;

public class ArraySeries
extends BasicSeries {
    private double @NonNull [] data;
    private boolean isPerFrame;

    public ArraySeries(@NonNull String name, double @NonNull [] data, boolean isPerFrame) {
        super(name);
        this.data = data;
        this.isPerFrame = isPerFrame;
    }

    public ArraySeries(@NonNull String name, double @NonNull [] data) {
        this(name, data, false);
    }

    public ArraySeries(@NonNull String name) {
        this(name, new double[0]);
    }

    public void setContent(double @NonNull [] data) {
        if (this.data.length != 0 && data.length != this.data.length) {
            throw new LogicError("ArraySeries assignment: invalid array length");
        }
        this.data = data;
    }

    @Override
    public int getLength() {
        return this.data.length;
    }

    @Override
    public boolean isPerFrame() {
        return this.isPerFrame;
    }

    @Override
    public boolean isPresent() {
        return true;
    }

    @Override
    public double @NonNull [] toArray() {
        if (!this.isPresent()) {
            throw new LogicError("No data for series " + this.getName());
        }
        return this.data;
    }
}

