/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.common;

import com.arm.streamline.performanceadvisor.Application;
import java.util.logging.Level;
import org.eclipse.jdt.annotation.NonNull;

public class ResourceProblem {
    private final @NonNull Severity severity;
    private final @NonNull String description;
    private final @NonNull String resolution;

    public ResourceProblem(@NonNull Severity severity, @NonNull String description, @NonNull String resolution) {
        this.severity = severity;
        this.description = description;
        this.resolution = resolution;
        String message = this.toString();
        switch (severity) {
            case ERROR: {
                Application.LOG.log(Level.SEVERE, message);
                break;
            }
            case WARNING: {
                Application.LOG.log(Level.WARNING, message);
                break;
            }
        }
    }

    public @NonNull Severity getSeverity() {
        return this.severity;
    }

    public @NonNull String getDescription() {
        return this.description;
    }

    public @NonNull String getResolution() {
        return this.resolution;
    }

    public String toString() {
        Object message = "";
        message = this.description.endsWith(".") ? (String)message + this.description + " " : (this.description.endsWith(System.lineSeparator()) ? (String)message + this.description : (String)message + this.description + ". ");
        if (!this.resolution.isEmpty()) {
            message = this.resolution.endsWith(".") || this.resolution.endsWith("%n") ? (String)message + this.resolution : (String)message + this.resolution + ".";
        }
        return message;
    }

    public static enum Severity {
        ERROR,
        WARNING;

    }
}

