/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.capturesource;

import com.arm.streamline.performanceadvisor.common.FatalError;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

public class TempDirectory {
    private Path dirPath = null;
    private Thread shutdownThread = null;

    public TempDirectory(String prefix) {
        try {
            this.dirPath = Files.createTempDirectory(prefix, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new FatalError("Failed to make a temporary directory: " + e.getMessage(), e);
        }
        boolean isMacOs = System.getProperty("os.name").toLowerCase().startsWith("mac");
        if (!isMacOs) {
            this.shutdownThread = new Thread(this::deleteDir);
            Runtime.getRuntime().addShutdownHook(this.shutdownThread);
        }
    }

    public Path getPath() {
        return this.dirPath;
    }

    public void close() {
        if (this.shutdownThread != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
            this.shutdownThread = null;
        }
        this.deleteDir();
    }

    private void deleteDir() {
        if (this.dirPath != null && Files.isDirectory(this.dirPath, new LinkOption[0])) {
            try {
                Files.walkFileTree(this.dirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    private void quietDelete(Path path) {
                        try {
                            Files.deleteIfExists(path);
                        }
                        catch (IOException e) {
                            System.err.println("Failed to delete " + String.valueOf(path));
                        }
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path path, IOException exc) throws IOException {
                        this.quietDelete(path);
                        return super.postVisitDirectory(path, exc);
                    }

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                        this.quietDelete(path);
                        return super.visitFile(path, attrs);
                    }
                });
                this.dirPath = null;
            }
            catch (IOException e) {
                System.err.println("Failed to delete " + String.valueOf(this.dirPath) + ": " + e.getMessage());
            }
        }
    }
}

