/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.capturesource;

import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.capturesource.CaptureHandler;
import com.arm.streamline.performanceadvisor.capturesource.HandlerReadOnly;
import com.arm.streamline.performanceadvisor.capturesource.HandlerStandard;
import com.arm.streamline.performanceadvisor.capturesource.HandlerZipFile;
import com.arm.streamline.performanceadvisor.common.FatalError;
import com.arm.streamline.performanceadvisor.common.Profiler;
import com.arm.streamline.performanceadvisor.io.UserProvidedPath;
import java.io.File;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

public class CaptureSource
implements AutoCloseable {
    private UserProvidedPath userPath;
    private File directory;
    private List<CaptureHandler> handlerList = new ArrayList<CaptureHandler>();
    private CaptureHandler handler = null;

    public CaptureSource(UserProvidedPath userPath) {
        Instant startTime = Instant.now();
        this.userPath = userPath;
        this.handlerList.add(new HandlerReadOnly());
        this.handlerList.add(new HandlerStandard());
        this.handlerList.add(new HandlerZipFile());
        for (CaptureHandler i : this.handlerList) {
            if (!i.canProcessCapture(userPath.getAdjustedPath())) continue;
            this.handler = i;
            break;
        }
        if (this.handler == null) {
            throw new FatalError("Invalid capture at \"" + String.valueOf(userPath.getUserProvidedPath()) + "\"");
        }
        this.directory = this.handler.workingDirectory(userPath);
        Application.PROFILER.record("CaptureSource", Profiler.Phase.INIT, "Setup", Duration.between(startTime, Instant.now()));
    }

    public File toFile() {
        return this.directory;
    }

    public Path toPath() {
        return this.directory.toPath();
    }

    public String getName() {
        return this.userPath.getUserProvidedPath().toString();
    }

    @Override
    public void close() {
        if (this.handler != null) {
            this.handler.close();
            this.directory = null;
            this.handler = null;
        }
    }
}

