/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.capturedata;

import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.model.capture.IChartDataProvider;
import com.arm.streamline.model.capture.ISeriesDataProvider;
import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.capturedata.Provider;
import com.arm.streamline.performanceadvisor.common.LogicError;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import java.util.HashSet;
import java.util.OptionalInt;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;

public class GpuTypeProvider
extends Provider {
    private @NonNull GpuType gpuType = GpuType.UNKNOWN;
    private @NonNull GpuFamily gpuFamily = GpuFamily.UNKNOWN;
    private OptionalInt shaderCoreCount = OptionalInt.empty();

    public GpuTypeProvider(CaptureData captureData) {
        super(captureData);
    }

    @Override
    public ProblemList initialise() {
        ProblemList problemList = new ProblemList();
        Set<String> maliTypes = this.findAllSeriesWithMaliDeviceType();
        if (maliTypes.size() > 1) {
            Application.LOG.fine(() -> "Warning: ambiguity when detecting GPU type: " + String.join((CharSequence)",", maliTypes));
        }
        if (!maliTypes.isEmpty()) {
            String deviceName = maliTypes.iterator().next();
            this.gpuType = GpuTypeProvider.fromCodename(deviceName);
            this.setFamily();
            if (this.gpuFamily == GpuFamily.UNKNOWN) {
                problemList.addError("Unsupported GPU type - " + deviceName, "Please contact Arm in regards to adding support.");
            }
        } else {
            this.gpuType = GpuType.UNKNOWN;
            this.gpuFamily = GpuFamily.UNKNOWN;
            problemList.addError("Cannot determine GPU type", "Make sure you are using a supported device and included the GPU counters in the capture by setting the relevant template.");
        }
        if (this.shaderCoreCount.isEmpty()) {
            problemList.addWarning("Cannot determine shader core count");
        }
        return problemList;
    }

    private @NonNull Set<@NonNull String> findAllSeriesWithMaliDeviceType() {
        HashSet<String> maliTypes = new HashSet<String>();
        for (IChartDataProvider c : this.captureData.getChartList()) {
            for (ISeriesDataProvider s : c.getSeries()) {
                double[] gpuCoresSeries;
                DeviceType deviceType = s.getCoreInformationProvider().getDeviceType();
                if (deviceType != null) {
                    String name = deviceType.getName();
                    if (name.startsWith("Mali-")) {
                        maliTypes.add(name.substring(5));
                    }
                    if (name.startsWith("Immortalis-")) {
                        maliTypes.add(name);
                    }
                }
                if (!c.getTitle().equals("Mali Constants") || !s.getName().equals("Shader Core Count") || (gpuCoresSeries = s.getData(0, 0, null)) == null || gpuCoresSeries[0] == 0.0) continue;
                this.shaderCoreCount = OptionalInt.of((int)gpuCoresSeries[0]);
            }
        }
        maliTypes.remove("CONST");
        return maliTypes;
    }

    private static @NonNull GpuType fromCodename(@NonNull String codename) {
        switch (codename) {
            case "T720": {
                return GpuType.MALI_T720;
            }
            case "T760": {
                return GpuType.MALI_T760;
            }
            case "T820": {
                return GpuType.MALI_T820;
            }
            case "T830": {
                return GpuType.MALI_T830;
            }
            case "T860": {
                return GpuType.MALI_T860;
            }
            case "T880": {
                return GpuType.MALI_T880;
            }
            case "G31": {
                return GpuType.MALI_G31;
            }
            case "G51": {
                return GpuType.MALI_G51;
            }
            case "G52": {
                return GpuType.MALI_G52;
            }
            case "G71": {
                return GpuType.MALI_G71;
            }
            case "G72": {
                return GpuType.MALI_G72;
            }
            case "G76": {
                return GpuType.MALI_G76;
            }
            case "G57": {
                return GpuType.MALI_G57;
            }
            case "G68": {
                return GpuType.MALI_G68;
            }
            case "G77": {
                return GpuType.MALI_G77;
            }
            case "G78": {
                return GpuType.MALI_G78;
            }
            case "G78AE": {
                return GpuType.MALI_G78AE;
            }
            case "G310": {
                return GpuType.MALI_G310;
            }
            case "G510": {
                return GpuType.MALI_G510;
            }
            case "G610": {
                return GpuType.MALI_G610;
            }
            case "G710": {
                return GpuType.MALI_G710;
            }
            case "G615": {
                return GpuType.MALI_G615;
            }
            case "G620": {
                return GpuType.MALI_G620;
            }
            case "G625": {
                return GpuType.MALI_G625;
            }
            case "G715": {
                return GpuType.MALI_G715;
            }
            case "Immortalis-G715": {
                return GpuType.IMMORTALIS_G715;
            }
            case "G720": {
                return GpuType.MALI_G720;
            }
            case "Immortalis-G720": {
                return GpuType.IMMORTALIS_G720;
            }
            case "G725": {
                return GpuType.MALI_G725;
            }
            case "G925": 
            case "Immortalis-G925": {
                return GpuType.IMMORTALIS_G925;
            }
            case "TMIx": {
                return GpuType.MALI_G71;
            }
            case "THEx": {
                return GpuType.MALI_G72;
            }
            case "TDVx": {
                return GpuType.MALI_G31;
            }
            case "TSIx": {
                return GpuType.MALI_G51;
            }
            case "TGOx": {
                return GpuType.MALI_G52;
            }
            case "TNOx": {
                return GpuType.MALI_G76;
            }
            case "TNAx": {
                return GpuType.MALI_G57;
            }
            case "TTRx": {
                return GpuType.MALI_G77;
            }
            case "TOTx": {
                return GpuType.MALI_G68;
            }
            case "TBOx": {
                return GpuType.MALI_G78;
            }
            case "TVIx": {
                return GpuType.MALI_G610;
            }
            case "TODx": {
                return GpuType.MALI_G710;
            }
            case "TTUx": {
                return GpuType.MALI_G715;
            }
            case "TTUx2": {
                return GpuType.MALI_G615;
            }
            case "T72x": {
                return GpuType.MALI_T720;
            }
            case "T76x": {
                return GpuType.MALI_T720;
            }
            case "T82x": {
                return GpuType.MALI_T820;
            }
            case "T83x": {
                return GpuType.MALI_T830;
            }
            case "T86x": {
                return GpuType.MALI_T860;
            }
            case "T88x": {
                return GpuType.MALI_T880;
            }
        }
        return GpuType.UNKNOWN;
    }

    private void setFamily() {
        switch (this.gpuType) {
            case MALI_T720: 
            case MALI_T760: 
            case MALI_T820: 
            case MALI_T830: 
            case MALI_T860: 
            case MALI_T880: {
                this.gpuFamily = GpuFamily.MIDGARD;
                break;
            }
            case MALI_G71: 
            case MALI_G72: 
            case MALI_G31: 
            case MALI_G51: 
            case MALI_G52: 
            case MALI_G76: {
                this.gpuFamily = GpuFamily.BIFROST;
                break;
            }
            case MALI_G57: 
            case MALI_G77: 
            case MALI_G68: 
            case MALI_G78: 
            case MALI_G78AE: {
                this.gpuFamily = GpuFamily.VALHALL_JM;
                break;
            }
            case MALI_G310: 
            case MALI_G510: 
            case MALI_G610: 
            case MALI_G710: {
                this.gpuFamily = GpuFamily.VALHALL_CSF;
                break;
            }
            case MALI_G615: 
            case MALI_G715: 
            case IMMORTALIS_G715: {
                this.gpuFamily = GpuFamily.VALHALL_RTU;
                break;
            }
            case MALI_G620: 
            case MALI_G720: 
            case IMMORTALIS_G720: 
            case MALI_G625: 
            case MALI_G725: 
            case IMMORTALIS_G925: {
                this.gpuFamily = GpuFamily.GEN5;
                break;
            }
            case UNKNOWN: {
                this.gpuFamily = GpuFamily.UNKNOWN;
                break;
            }
            default: {
                throw new LogicError("Could not set GPU family for type " + this.gpuType.toString());
            }
        }
    }

    @Override
    public void execute() {
    }

    public GpuFamily getFamily() {
        return this.gpuFamily;
    }

    public GpuType getType() {
        return this.gpuType;
    }

    public String getPrettyType() {
        if (this.gpuType.toString().contains("MALI_")) {
            return this.gpuType.toString().replace("MALI_", "Mali-");
        }
        if (this.gpuType.toString().contains("IMMORTALIS_")) {
            return this.gpuType.toString().replace("IMMORTALIS_", "Immortalis-");
        }
        return this.gpuType.toString();
    }

    public OptionalInt getShaderCoreCount() {
        return this.shaderCoreCount;
    }

    public static enum GpuFamily {
        UNKNOWN,
        MIDGARD,
        BIFROST,
        VALHALL_JM,
        VALHALL_CSF,
        VALHALL_RTU,
        GEN5;

    }

    public static enum GpuType {
        UNKNOWN,
        MALI_T720,
        MALI_T760,
        MALI_T820,
        MALI_T830,
        MALI_T860,
        MALI_T880,
        MALI_G71,
        MALI_G72,
        MALI_G31,
        MALI_G51,
        MALI_G52,
        MALI_G76,
        MALI_G57,
        MALI_G77,
        MALI_G68,
        MALI_G78,
        MALI_G78AE,
        MALI_G310,
        MALI_G510,
        MALI_G610,
        MALI_G710,
        MALI_G615,
        MALI_G715,
        IMMORTALIS_G715,
        MALI_G620,
        MALI_G720,
        IMMORTALIS_G720,
        MALI_G625,
        MALI_G725,
        IMMORTALIS_G925;

    }
}

