/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.capturedata;

import com.arm.streamline.common.model.counters.CounterDisplay;
import com.arm.streamline.jni.apcdbgen.proto.ICAMJob;
import com.arm.streamline.jni.apcdbgen.proto.ICAMTrack;
import com.arm.streamline.model.capture.Bookmark;
import com.arm.streamline.model.capture.IChartDataProvider;
import com.arm.streamline.model.capture.ISeriesDataProvider;
import com.arm.streamline.model.process.ITimelineRowProvider;
import com.arm.streamline.model.process.ThreadAnnotation;
import com.arm.streamline.model.process.TimelineRow;
import com.arm.streamline.pa.StreamlineGaData;
import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.capturedata.Frame;
import com.arm.streamline.performanceadvisor.capturedata.Provider;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.common.VectorUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import org.eclipse.jdt.annotation.Checks;
import org.eclipse.jdt.annotation.Nullable;

public class FrameProvider
extends Provider {
    private List<Frame> frames = new ArrayList<Frame>();
    private boolean initError = false;
    private Optional<String> primaryContextName;
    private static final double TO_MS = 1000000.0;

    public FrameProvider(CaptureData captureData, Optional<String> primaryContextName) {
        super(captureData);
        this.primaryContextName = primaryContextName;
    }

    public List<Frame> getFrames() {
        return this.frames;
    }

    public double[] getFrameStarts() {
        return this.frames.stream().mapToDouble(Frame::getStart).toArray();
    }

    public Frame getFirstFrame() {
        return this.frames.get(0);
    }

    public Frame getLastFrame() {
        return this.frames.get(this.frames.size() - 1);
    }

    public int getNumFrames() {
        return this.frames.size();
    }

    public int getStartIndex(int i) {
        return this.frames.get(i).getStart();
    }

    public int getEndIndex(int i) {
        return this.frames.get(i).getEnd();
    }

    public double getLength(int i) {
        return this.frames.get(i).getScreenTime();
    }

    public int timeToFrame(int time) {
        int frameNum = Arrays.binarySearch(this.getFrameStarts(), (double)time);
        if (frameNum < 0) {
            frameNum *= -1;
            --frameNum;
        }
        return frameNum;
    }

    public boolean hasError() {
        return this.initError;
    }

    @Override
    public ProblemList initialise() {
        ProblemList problemList = new ProblemList();
        List<Frame> rawFrames = this.initialiseGaFrames();
        if (rawFrames.isEmpty()) {
            rawFrames = this.initialiseLwiFrames();
        }
        if (rawFrames.isEmpty()) {
            rawFrames = this.initialiseBookmarkFrames(problemList);
        }
        if (rawFrames.isEmpty()) {
            this.initialiseUserFrames(problemList);
        }
        if (rawFrames.isEmpty()) {
            problemList.addError("Cannot find any frames", "Please refer to the user guide for methods of providing frame data to Performance Advisor.");
        } else {
            FrameProvider.logFrameList(rawFrames);
            this.cullFrames(rawFrames);
            this.frames = this.normaliseFrames(rawFrames);
            assert (FrameProvider.framesAreContiguous(this.frames));
        }
        this.initError = problemList.hasError();
        return problemList;
    }

    @Override
    public void execute() {
    }

    private void cullFrames(List<Frame> rawFrames) {
        int limit = this.captureData.getBinCount();
        int i = rawFrames.size() - 1;
        while (i > 0) {
            if (rawFrames.get(i).getEnd() <= limit) break;
            rawFrames.remove(i);
            --i;
        }
    }

    private List<Frame> initialiseBookmarkFrames(ProblemList problemList) {
        List bookmarkFrames = this.captureData.getBookmarks("F").sorted((b0, b1) -> Long.compare(b0.getTimestamp(), b1.getTimestamp())).collect(Collectors.toList());
        ArrayList<Frame> frameList = new ArrayList<Frame>();
        if (bookmarkFrames.size() < 3) {
            return frameList;
        }
        int frameStart = (int)Math.round((double)((Bookmark)bookmarkFrames.get(0)).getTimestamp() / 1000000.0);
        int i = 1;
        while (i < bookmarkFrames.size()) {
            int frameEnd = (int)Math.round((double)((Bookmark)bookmarkFrames.get(i)).getTimestamp() / 1000000.0);
            frameList.add(new Frame(frameStart, frameEnd + 1));
            frameStart = frameEnd + 1;
            ++i;
        }
        Application.LOG.config("Found bookmark frame markers");
        problemList.addWarning("Using bookmark frame markers", "Include the lightweight interceptor or Graphics Analyzer interceptor to generate these automatically.");
        return frameList;
    }

    public List<Frame> initialiseGaFrames() {
        List frameJobs;
        ArrayList<Frame> frameList = new ArrayList<Frame>();
        StreamlineGaData graphicsAnalyser = this.captureData.getGaData();
        if (graphicsAnalyser == null || graphicsAnalyser.getCamJobsSize() < 1) {
            return frameList;
        }
        int jobIndex = 0;
        int frameStart = 0;
        if (this.primaryContextName.isEmpty()) {
            this.primaryContextName = Optional.of(graphicsAnalyser.guessPrimaryContextName());
        }
        if ((frameJobs = graphicsAnalyser.getCamJobsForContext(this.primaryContextName.get()).collect(Collectors.toList())).isEmpty()) {
            return frameList;
        }
        frameStart = (int)((double)((ICAMJob)frameJobs.get(0)).getStartTime() / 1000000.0);
        int latestFrameIndex = jobIndex;
        while (jobIndex < frameJobs.size() - 1) {
            int frameEnd;
            if ((frameEnd = (int)Math.round((double)((ICAMJob)frameJobs.get(++jobIndex)).getStartTime() / 1000000.0)) + 1 <= frameStart) continue;
            latestFrameIndex = jobIndex;
            frameList.add(new Frame(frameStart, frameEnd + 1));
            frameStart = frameEnd + 1;
        }
        int finalFrameEnd = (int)Math.round((double)((ICAMJob)frameJobs.get(latestFrameIndex)).getStopTime() / 1000000.0);
        frameList.add(new Frame(frameStart, Math.max(frameStart, finalFrameEnd) + 1));
        Application.LOG.config("Found GA frame markers");
        return frameList;
    }

    private List<Frame> initialiseLwiFrames() {
        ArrayList<Frame> frameList = new ArrayList<Frame>();
        Optional<double[]> data = this.captureData.getSeriesForName("Frame End (eglSwapBuffer)", null).map(s -> (double[])Checks.requireNonNull((Object)s.getData(0, this.captureData.getBinCount(), null)));
        if (!data.isPresent()) {
            return frameList;
        }
        double[] frameEnds = data.get();
        List frameEndsList = DoubleStream.of(frameEnds).boxed().collect(Collectors.toList());
        int frameStart = frameEndsList.indexOf(1.0);
        int i = frameStart + 1;
        while (i < frameEnds.length) {
            if (frameEnds[i] == 1.0) {
                frameList.add(new Frame(frameStart, i + 1));
                frameStart = i + 1;
            }
            ++i;
        }
        Application.LOG.config("Found LWI frame markers");
        return frameList;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private List<Frame> initialiseUserFrames(ProblemList problemList) {
        ThreadAnnotation a;
        ArrayList<Frame> frameList = new ArrayList<Frame>();
        ITimelineRowProvider annotationRow = this.captureData.findChannel("Frame Markers");
        if (!(annotationRow instanceof TimelineRow)) {
            return frameList;
        }
        List<@Nullable ThreadAnnotation> annotationData = annotationRow.getAnnotationData(0, this.captureData.getBinCount());
        int frameStart = 0;
        int i = 0;
        while (i < annotationData.size()) {
            a = annotationData.get(i);
            if (a != null && a.isStartFrame()) {
                frameStart = i;
                break;
            }
            ++i;
        }
        i = frameStart + 1;
        while (i < annotationData.size()) {
            a = annotationData.get(i);
            if (a != null && a.isStartFrame()) {
                frameList.add(new Frame(frameStart, i));
                frameStart = i + 1;
            }
            ++i;
        }
        i = annotationData.size() - 1;
        while (i > 0) {
            a = annotationData.get(i);
            if (a != null && a.isEndFrame()) {
                frameList.add(new Frame(frameStart, i));
                break;
            }
            --i;
        }
        Application.LOG.config("Found user frame markers");
        problemList.addWarning("Using user defined frame markers", "Include the lightweight interceptor or Graphics Analyzer interceptor to generate these automatically.");
        return frameList;
    }

    public List<Frame> normaliseFrames(List<Frame> frameList) {
        Optional<IChartDataProvider> frameRateCounter = this.captureData.getChartList().stream().filter(c -> c.getTitle().contains("Frame Rate")).findFirst();
        if (frameRateCounter.isEmpty()) {
            return frameList;
        }
        List<ISeriesDataProvider> fpsList = frameRateCounter.get().getSeries();
        double[] fps = new double[this.captureData.getBinCount()];
        for (ISeriesDataProvider fpsSeries : fpsList) {
            fpsSeries.getConfig().setDisplay(CounterDisplay.AVERAGE);
            if (this.primaryContextName.isEmpty()) {
                fps = VectorUtils.add(fps, fpsSeries.getData(0, this.captureData.getBinCount() - 1, null));
                continue;
            }
            if (!fpsSeries.getName().contains(this.primaryContextName.get())) continue;
            fps = fpsSeries.getData(0, this.captureData.getBinCount() - 1, null);
            break;
        }
        for (Frame frame : frameList) {
            double framePeriod;
            if (frame.getStart() >= fps.length - 1 || !((framePeriod = 1000.0 / fps[frame.getStart() + 1]) < 67.0)) continue;
            frame.setScreenTime(framePeriod);
        }
        return frameList;
    }

    private static @Nullable ICAMTrack traverse(ICAMTrack child, int size) {
        ICAMTrack track = null;
        if (child.getTitle().equals("Frames") && child.getAllJobs().size() > size) {
            track = child;
        } else {
            for (ICAMTrack each : child.getChildren()) {
                ICAMTrack temp = FrameProvider.traverse((ICAMTrack)Checks.requireNonNull((Object)each), size);
                if (temp == null) continue;
                track = temp;
                size = track.getAllJobs().size();
            }
        }
        return track;
    }

    private static void logFrameList(List<Frame> frames) {
        Application.LOG.fine(() -> String.format("FrameProvider found %d frames.", frames.size()));
        if (Application.LOG.isLoggable(Level.FINEST)) {
            int idx = 0;
            for (Frame i : frames) {
                Application.LOG.finest(String.format("Frame %d: %d - %d (%f)", idx++, i.getStart(), i.getEnd(), i.getScreenTime()));
            }
        }
    }

    private static boolean framesAreContiguous(List<Frame> frames) {
        boolean result = true;
        int i = 1;
        while (i < frames.size()) {
            int previousEnd = frames.get(i - 1).getEnd();
            int start = frames.get(i).getStart();
            if (start != previousEnd) {
                if (Application.LOG.isLoggable(Level.SEVERE)) {
                    Application.LOG.severe(String.format("Frames %d and %d are not contiguous: %d-%d, %d-%d", i - 1, i, frames.get(i - 1).getStart(), previousEnd, start, frames.get(i).getEnd()));
                }
                result = false;
                break;
            }
            ++i;
        }
        return result;
    }
}

