/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.capturedata;

import com.arm.streamline.performanceadvisor.common.LogicError;
import java.util.Objects;

public class Frame {
    private final int start;
    private final int end;
    private double screenTime = -1.0;

    public Frame(int start, int end) {
        if (start < 0 || end <= start) {
            throw new LogicError("Frame: invalid parameters");
        }
        this.start = start;
        this.end = end;
    }

    public Frame(int start, int end, double period) {
        this(start, end);
        this.screenTime = period;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setScreenTime(double period) {
        this.screenTime = period;
    }

    public double getScreenTime() {
        return this.screenTime > 0.0 ? this.screenTime : (double)(this.end - this.start);
    }

    public int getDrawTime() {
        return this.end - this.start;
    }

    public int hashCode() {
        return Objects.hash(this.end, this.screenTime, this.start);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Frame other = (Frame)obj;
        return this.end == other.end && Double.doubleToLongBits(this.screenTime) == Double.doubleToLongBits(other.screenTime) && this.start == other.start;
    }
}

