/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.capturedata;

import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.model.capture.IChartDataProvider;
import com.arm.streamline.model.capture.ISeriesDataProvider;
import com.arm.streamline.model.capture.SeriesConfig;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.capturedata.Provider;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CustomChartListProvider
extends Provider {
    private List<String> chartTitles = Collections.emptyList();
    private Pattern constantDivision = Pattern.compile("/\\s?\\d+\\)");

    public CustomChartListProvider(CaptureData captureData) {
        super(captureData);
    }

    public List<String> getTitles() {
        return this.chartTitles;
    }

    public boolean isValidTitle(String chartTitle) {
        return this.chartTitles.contains(chartTitle);
    }

    @Override
    public ProblemList initialise() {
        this.chartTitles = new ArrayList<String>();
        List<IChartDataProvider> chartProviders = this.captureData.getUniqueSortedChartList();
        for (IChartDataProvider chart : chartProviders) {
            if (!this.chartProviderIsValid(chart)) continue;
            this.chartTitles.add(chart.getTitle());
        }
        Comparator maliFirst = (s1, s2) -> (s2.startsWith("Mali") ? 1 : 0) - (s1.startsWith("Mali") ? 1 : 0);
        this.chartTitles.sort(maliFirst.thenComparing(Comparator.naturalOrder()));
        return new ProblemList();
    }

    @Override
    public void execute() {
    }

    private boolean chartProviderIsValid(IChartDataProvider chart) {
        return !CustomChartListProvider.isCpuCounter(chart) && !this.isDivisionExpression(chart) && !CustomChartListProvider.isFrameRateCounter(chart) && !CustomChartListProvider.isMaliConstants(chart);
    }

    private static boolean isCpuCounter(IChartDataProvider chart) {
        IChartDataProvider.IChartCoreInformationProvider chartCoreInfo = chart.getCoreInformationProvider();
        DeviceType deviceType = chartCoreInfo.getDeviceType();
        return deviceType != null && deviceType.isCPU();
    }

    private boolean isDivisionExpression(IChartDataProvider chart) {
        boolean isDivisionExpression = false;
        for (ISeriesDataProvider series : chart.getSeries()) {
            SeriesConfig config = series.getConfig();
            String expression = config.getExpression().getString();
            Matcher matcher = this.constantDivision.matcher(expression);
            if (matcher.find()) {
                expression = matcher.replaceAll("\\)");
            }
            if (!expression.contains("/")) continue;
            isDivisionExpression = true;
            break;
        }
        return isDivisionExpression;
    }

    private static boolean isFrameRateCounter(IChartDataProvider chart) {
        String title = chart.getTitle().toLowerCase();
        return title.contains("frame rate") || title.contains("fps") || title.contains("frame end");
    }

    private static boolean isMaliConstants(IChartDataProvider chart) {
        return chart.getTitle().equals("Mali Constants");
    }
}

