/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.capturedata;

import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.capturedata.Provider;
import com.arm.streamline.performanceadvisor.common.LogicError;
import com.arm.streamline.performanceadvisor.common.ProblemList;

public class CheckedProvider
extends Provider {
    private Provider provider;
    private ProblemList problemList;
    private boolean isInitialised;
    private boolean isExecuted;

    public CheckedProvider(Provider provider) {
        super(provider.captureData);
        this.provider = provider;
        this.problemList = new ProblemList();
        this.isInitialised = false;
    }

    @Override
    public String name() {
        return this.provider.name();
    }

    @Override
    public ProblemList initialise() {
        if (!this.isInitialised) {
            Application.LOG.fine(() -> String.format("%s.initialise()", this.provider.name()));
            this.problemList = this.provider.initialise();
            this.isInitialised = true;
        }
        return this.problemList;
    }

    @Override
    public void execute() {
        Application.LOG.fine(() -> this.name() + ".execute()");
        if (!this.isInitialised) {
            throw new LogicError("Provider " + this.name() + " has not been initialised");
        }
        if (this.problemList.hasError()) {
            throw new LogicError("Provider " + this.name() + " reported errors and so can't be executed");
        }
        if (!this.isExecuted) {
            this.provider.execute();
            this.isExecuted = true;
        }
    }
}

