/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.analyser;

import com.arm.streamline.performanceadvisor.analyser.Analyser;
import com.arm.streamline.performanceadvisor.analyser.AnalyserFactory;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.capturedata.ClippedRegionsProvider;
import com.arm.streamline.performanceadvisor.capturedata.FpsProvider;
import com.arm.streamline.performanceadvisor.capturedata.Region;
import com.arm.streamline.performanceadvisor.common.LogicError;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.common.VectorUtils;
import com.arm.streamline.performanceadvisor.section.Element;
import com.arm.streamline.performanceadvisor.section.ElementGroup;
import com.arm.streamline.performanceadvisor.section.ElementType;
import com.arm.streamline.performanceadvisor.section.GaugeChart;
import com.arm.streamline.performanceadvisor.section.Section;
import com.arm.streamline.performanceadvisor.section.TextBlock;
import com.arm.streamline.performanceadvisor.section.TextStyle;
import com.arm.streamline.performanceadvisor.section.Unit;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;

public class RegionSummaryAnalyserFactory
extends AnalyserFactory {
    @Override
    public Analyser create(CaptureData captureData) {
        return new RegionSummaryAnalyser(captureData);
    }

    public class RegionSummaryAnalyser
    extends Analyser {
        private ClippedRegionsProvider clippedRegionsProvider;
        private FpsProvider fpsProvider;
        private static final int FPS_SERIES_DECIMAL_PLACES = 2;
        private static final int ELEMENTS_PER_GROUP = 6;

        public RegionSummaryAnalyser(CaptureData captureData) {
            super(captureData);
        }

        @Override
        public ProblemList initialise() {
            this.clippedRegionsProvider = this.captureData.getClippedRegionsProvider();
            this.fpsProvider = this.captureData.getFpsProvider();
            return new ProblemList();
        }

        @Override
        public Section execute(int userRegion) {
            if (userRegion != 0) {
                throw new LogicError("Only for the overall capture");
            }
            ArrayList<Element> elements = new ArrayList<Element>();
            if (this.clippedRegionsProvider.getClippedUserRegions().size() > 0) {
                elements.add(new TextBlock(TextStyle.H2_HIDDEN, "Region summary", "<p> These charts show the average frame rate for each region in the capture. </p>"));
            }
            ArrayList<Element> groupedElements = new ArrayList<Element>();
            int groupCounter = 0;
            for (Region region : this.clippedRegionsProvider.getClippedUserRegions()) {
                double avgFrameSeries = VectorUtils.avg(Arrays.copyOfRange(this.fpsProvider.getPerBin().getSeriesToDisplay().toArray(), region.getStart(), region.getEnd()));
                avgFrameSeries = BigDecimal.valueOf(avgFrameSeries).setScale(2, RoundingMode.HALF_UP).doubleValue();
                String frameSeriesChartTitle = "Average " + this.fpsProvider.getPerFrame().getNameToDisplayLong();
                Unit frameSeriesChartUnit = this.fpsProvider.getPerFrame().getUnitToDisplay();
                if (!this.captureData.getTargetFrameRate().getDisplayAsFrameTime()) {
                    groupedElements.add(new GaugeChart(frameSeriesChartTitle, avgFrameSeries, this.captureData.getTargetFrameRate().getAsFps(), frameSeriesChartUnit, region.getName(), region.getName(), "#" + region.getId()));
                }
                if (++groupCounter % 6 != 0) continue;
                elements.add(new ElementGroup("perRegionPerformance", new ArrayList<Element>(groupedElements)));
                groupedElements.clear();
            }
            if (!groupedElements.isEmpty()) {
                elements.add(new ElementGroup("perRegionPerformance", groupedElements));
                while (groupCounter % 6 != 0) {
                    groupedElements.add(new Element(ElementType.EMPTY));
                    ++groupCounter;
                }
            }
            for (Element e : elements) {
                e.setExcludeFromJson(true);
            }
            return new Section("regionSummary", elements);
        }
    }
}

