/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.analyser;

import com.arm.streamline.performanceadvisor.Options;
import com.arm.streamline.performanceadvisor.analyser.Analyser;
import com.arm.streamline.performanceadvisor.analyser.AnalyserFactory;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.capturedata.GpuTypeProvider;
import com.arm.streamline.performanceadvisor.common.LogicError;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.section.Element;
import com.arm.streamline.performanceadvisor.section.KeyValue;
import com.arm.streamline.performanceadvisor.section.Section;
import com.arm.streamline.performanceadvisor.section.TextBlock;
import com.arm.streamline.performanceadvisor.section.TextStyle;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;

public class HeaderAnalyserFactory
extends AnalyserFactory {
    private static final String UNKNOWN_GPU_TYPE = "UNKNOWN";

    @Override
    public Analyser create(CaptureData captureData) {
        return new HeaderAnalyser(captureData);
    }

    public class HeaderAnalyser
    extends Analyser {
        private Options options;
        private GpuTypeProvider gpuTypeProvider;
        private String appBuildName;
        private String appBuildTimestamp;
        private String deviceName;

        public HeaderAnalyser(CaptureData captureData) {
            super(captureData);
            this.appBuildName = null;
            this.appBuildTimestamp = null;
            this.deviceName = null;
        }

        @Override
        public ProblemList initialise() {
            ProblemList problemList = new ProblemList();
            this.options = this.captureData.getOptions();
            this.gpuTypeProvider = this.captureData.getGpuTypeProvider();
            this.appBuildName = this.options.getAppBuildName();
            this.appBuildTimestamp = this.options.getAppBuildTimestamp();
            if (this.appBuildName == null) {
                problemList.addWarning("Build name not provided", "You can add this as a command line argument (use --build-name)");
            }
            if (this.appBuildTimestamp == null) {
                problemList.addWarning("Build timestamp not provided", "You can add this as a command line argument (use --build-timestamp)");
            }
            this.deviceName = this.options.getDeviceName();
            if (this.deviceName == null) {
                problemList.addWarning("Device name not provided", "You can add this as a command line argument (use --device-name).");
            }
            return problemList;
        }

        @Override
        public Section execute(int userRegion) {
            if (userRegion != 0) {
                throw new LogicError("HeaderAnalyser can't be applied to a user region");
            }
            ArrayList<Element> elements = new ArrayList<Element>();
            elements.add(new TextBlock(TextStyle.REPORT_TITLE, this.options.getAppName()));
            Object buildInfoMessage = this.appBuildName;
            if (this.appBuildTimestamp != null) {
                buildInfoMessage = buildInfoMessage != null ? (String)buildInfoMessage + ", " + this.appBuildTimestamp : this.appBuildTimestamp;
            }
            KeyValue jsonBuildInfo = new KeyValue("Build", (String)buildInfoMessage);
            if (buildInfoMessage == null) {
                jsonBuildInfo.setExcludeFromHtml(true);
            }
            String deviceInfoMessage = this.deviceName;
            String gpuName = this.gpuTypeProvider.getPrettyType();
            if (gpuName != null && !gpuName.equals(HeaderAnalyserFactory.UNKNOWN_GPU_TYPE)) {
                if (deviceInfoMessage == null) {
                    deviceInfoMessage = gpuName;
                }
            } else {
                String machineName = this.captureData.getMachineName();
                if (!machineName.equals("unknown") && deviceInfoMessage == null) {
                    deviceInfoMessage = machineName;
                }
            }
            KeyValue jsonDeviceInfo = new KeyValue("Device", deviceInfoMessage);
            if (deviceInfoMessage == null) {
                jsonDeviceInfo.setExcludeFromHtml(true);
            }
            StringBuilder procInfo = new StringBuilder();
            List<String> cpus = this.captureData.getProcessors();
            for (String cpu : cpus) {
                procInfo.append(cpu + ", ");
            }
            procInfo.append(this.gpuTypeProvider.getPrettyType());
            procInfo.append(this.getShaderCoreCount());
            String deviceInfoTitle = "Device information";
            String missingData = this.generateMissingDataMessage();
            if (!missingData.isEmpty()) {
                elements.add(new TextBlock(TextStyle.H1_HIDDEN, deviceInfoTitle, missingData + "<br>"));
            } else {
                elements.add(new TextBlock(TextStyle.H1, deviceInfoTitle, missingData));
            }
            elements.add(jsonBuildInfo);
            elements.add(jsonDeviceInfo);
            elements.add(new KeyValue("Processors", procInfo.toString()));
            return new Section("deviceInfo", elements);
        }

        private String generateMissingDataMessage() {
            Object missingData = "";
            if (this.appBuildName == null) {
                missingData = (String)missingData + "<p></p>Add your build name to this section using the <span style = 'font-family:monospace';>--build-name</span> option on the command line";
            }
            if (this.appBuildTimestamp == null) {
                missingData = (String)missingData + "<p></p>Add your build timestamp to this section using the <span style = 'font-family:monospace';>--build-timestamp</span> option on the command line";
            }
            if (this.deviceName == null) {
                missingData = (String)missingData + "<p></p>Add your device name to this section using the <span style = 'font-family:monospace';>--device-name</span> option on the command line";
            }
            return missingData;
        }

        public String getShaderCoreCount() {
            OptionalInt coreCount = this.captureData.getGpuTypeProvider().getShaderCoreCount();
            if (coreCount.isPresent()) {
                return String.format(" MP%d", coreCount.getAsInt());
            }
            return "";
        }
    }
}

