/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.perf.transform;

import com.arm.streamline.common.xml.counters.Category;
import com.arm.streamline.common.xml.counters.StockCounter;
import com.arm.streamline.perf.InvalidPerfDataException;
import com.arm.streamline.perf.apc.EventsXml;
import com.arm.streamline.perf.records.EventAttribute;
import com.arm.streamline.perf.transform.CapturedCounter;
import com.arm.streamline.perf.transform.ClusterCoreMapping;
import com.arm.streamline.perf.transform.IPerfTransformMonitor;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import org.eclipse.jdt.annotation.NonNull;

public class CapturedCounters {
    private final @NonNull Map<@NonNull EventAttribute, @NonNull CapturedCounter> mappings;
    private final @NonNull Map<String, List<StockCounter>> allocatedCounterHandles = new HashMap<String, List<StockCounter>>();
    private final @NonNull TIntObjectMap<Category> customPmuCategories = new TIntObjectHashMap();
    private final @NonNull Map<String, Category> customTracepointCategories = new HashMap<String, Category>();
    private final @NonNull IntFunction<@NonNull String> pmuMappings;

    public CapturedCounters(@NonNull IPerfTransformMonitor monitor, @NonNull IntFunction<@NonNull String> pmuMappings, @NonNull Collection<@NonNull Map.Entry<@NonNull EventAttribute, @NonNull String>> events, @NonNull ToIntFunction<@NonNull EventAttribute> keys, @NonNull EventsXml eventsXml, @NonNull ClusterCoreMapping clusterCoreMap) throws InvalidPerfDataException, IOException, InterruptedException {
        this.pmuMappings = pmuMappings;
        this.mappings = new HashMap<EventAttribute, CapturedCounter>();
        for (Map.Entry<EventAttribute, String> entry : events) {
            EventAttribute eventAttribute = entry.getKey();
            String eventName = entry.getValue();
            int key = keys.applyAsInt(eventAttribute);
            CapturedCounter counter = CapturedCounter.create(this, eventAttribute, key, eventName, pmuMappings, eventsXml, clusterCoreMap);
            if (counter == null) {
                counter = CapturedCounter.customCounter(this, eventAttribute, key, eventName);
            }
            this.mappings.put(eventAttribute, counter);
            monitor.incProgress();
        }
    }

    public @NonNull String allocateCounterHandle(@NonNull String name, @NonNull StockCounter counter) {
        int index;
        List<StockCounter> list = this.allocatedCounterHandles.get(name);
        if (list == null) {
            list = new ArrayList<StockCounter>();
            this.allocatedCounterHandles.put(name, list);
        }
        if ((index = list.indexOf(counter)) < 0) {
            index = list.size();
            list.add(counter);
        }
        return name + index;
    }

    public @NonNull Map<@NonNull EventAttribute, @NonNull CapturedCounter> getMappings() {
        return Collections.unmodifiableMap(this.mappings);
    }

    public @NonNull Category makeCategory(@NonNull EventAttribute eventAttribute, @NonNull String name) throws InvalidPerfDataException {
        int type = eventAttribute.getType();
        if (type == 2) {
            String[] nameParts = name.split(":", 2);
            String categoryName = nameParts.length == 2 ? String.format("'%s' tracepoints", nameParts[0]) : this.pmuMappings.apply(type);
            Category result = this.customTracepointCategories.get(categoryName);
            if (result == null) {
                result = new Category(categoryName, true, true);
                this.customTracepointCategories.put(categoryName, result);
            }
            return result;
        }
        Category result = (Category)this.customPmuCategories.get(type);
        if (result == null) {
            String categoryName = this.pmuMappings.apply(type);
            result = new Category(categoryName, true, true);
            this.customPmuCategories.put(type, (Object)result);
        }
        return result;
    }
}

