/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.perf.data_file.header_flag_values;

import com.arm.streamline.perf.data_file.HeaderFlags;
import com.arm.streamline.perf.io.StringIO;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public final class NumaNode {
    private final int nodeNumber;
    private final long memTotal;
    private final long memFree;
    private final @NonNull String cpus;

    public static @NonNull List<@NonNull NumaNode> create(@NonNull DataInput input) throws IOException {
        ArrayList<@NonNull NumaNode> nodes = new ArrayList<NumaNode>();
        int nr = input.readInt();
        int i = 0;
        while (i < nr) {
            nodes.add(new NumaNode(input));
            ++i;
        }
        return nodes;
    }

    public NumaNode(@NonNull DataInput input) throws IOException {
        this.nodeNumber = input.readInt();
        this.memTotal = input.readLong();
        this.memFree = input.readLong();
        this.cpus = StringIO.stripNullTerminator((String)HeaderFlags.readHeaderString(input));
    }

    public boolean equals(Object obj) {
        if (obj instanceof NumaNode) {
            NumaNode that = (NumaNode)obj;
            return this.nodeNumber == that.nodeNumber && this.memTotal == that.memTotal && this.memFree == that.memFree && this.cpus.equals(that.cpus);
        }
        return false;
    }

    public @NonNull String getCpus() {
        return this.cpus;
    }

    public long getMemFree() {
        return this.memFree;
    }

    public long getMemTotal() {
        return this.memTotal;
    }

    public int getNumaTopologyNumber() {
        return this.nodeNumber;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.nodeNumber;
        result = 31 * result + (int)(this.memTotal ^ this.memTotal >>> 32);
        result = 31 * result + (int)(this.memFree ^ this.memFree >>> 32);
        result = 31 * result + this.cpus.hashCode();
        return result;
    }

    public String toString() {
        return String.format("NumaNode [nodeNumber=%s, memTotal=%s, memFree=%s, cpus=%s]", this.nodeNumber, this.memTotal, this.memFree, this.cpus);
    }
}

