/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.pa;

import com.arm.streamline.model.capture.ISeriesDataProvider;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.jdt.annotation.NonNull;

public class StreamlineDataRepository {
    private final HashMap<String, double[]> dataSet = new HashMap();
    private final HashMap<String, double[]> expressionDataSet = new HashMap();
    private final int binCount;

    public StreamlineDataRepository(int binCount) {
        this.binCount = binCount;
    }

    public double[] getData(ISeriesDataProvider seriesProvider) {
        return this.getData(seriesProvider, 0, this.binCount - 1);
    }

    public double[] getData(ISeriesDataProvider seriesProvider, int start, int end) {
        String name = seriesProvider.getChart().getTitle() + seriesProvider.getName();
        if (!this.dataSet.containsKey(name)) {
            double[] data = seriesProvider.getData(0, this.binCount - 1, null);
            this.dataSet.put(name, data);
        }
        return Arrays.copyOfRange(this.dataSet.get(name), start, end + 1);
    }

    public double[] getDataFromExpressions(@NonNull String expression, ISeriesDataProvider seriesProvider, int start, int end) {
        if (!this.expressionDataSet.containsKey(expression)) {
            double[] data = seriesProvider.getData(0, this.binCount - 1, null);
            this.expressionDataSet.put(expression, data);
        }
        return Arrays.copyOfRange(this.expressionDataSet.get(expression), start, end + 1);
    }
}

